/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/

#ifndef  _PO_CARTESIAN_AXIS_
#define  _PO_CARTESIAN_AXIS_

#include <MeshViz/graph/PoAxis.h>
#include <MeshViz/graph/PbDomain.h>


#include <Inventor/fields/SoSFEnum.h>
#include <Inventor/fields/SoSFFloat.h>
#include <Inventor/fields/SoSFVec3f.h>


class SoTransform ;

/**
 * @DTEXT  Abstract class for cartesian axes.
 * 
 * @ingroup GraphAxis
 * 
 * @DESCRIPTION
 *    This class handles the start, end, and the type of 
 *    the cartesian axis.
 * 
 */
class MESHVIZ_API PoCartesianAxis : public PoAxis {

  SO_KIT_HEADER(PoCartesianAxis) ;


 public:



  /* Fields */

  /**
   * Defines the start of the axis.
   */
  SoSFVec3f start ;

  /**
   * Defines the end of the axis.
   */
  SoSFFloat end ;

  /**
   * Defines the value of the graduation (tick label) corresponding to the starting coordinate of this axis.
   * For instance if an horizontal axis #start is (5,0,0), the #end is 10, the #gradStart is -3 and
   * #gradEnd is +4, the X coordinates of this horizontal axis are in the range [5, 10], but the
   * text of the displayed graduations are in the range [-3, +4] for linear axis and in the range
   * [10E-3, 10E+4] for logarithmic axis.
   *
   * If #gradStart and #gradEnd are equal, these fields are ignored and the text of the
   * graduations correspond to the coordinates of the axis.
   *
   * This field is ignored by PoGenAxis.
   *
   * @M_SINCE 9.5.1
   */
  SoSFFloat gradStart;

  /**
   * Defines the value of the graduation (tick label) corresponding to the end coordinate of this axis.
   * See #gradStart for details.
   * 
   * This field is ignored by PoGenAxis.
   *
   * @M_SINCE 9.5.1
   */
  SoSFFloat gradEnd;

  /**
   * Type of the axis (XY, XZ, YX, ... axis).
   * For instance if the type is XY, it means an X-Axis in the plane XY.
   */
  SoSFEnum  type ;

  /**
   *  Type of axis orientation.
   */
  enum Type {
    /**
     *  X-Axis in the plane XY
     */
    XY,       
    /**
     *  X-Axis in the plane XZ
     */
    XZ,       
    /**
     *  Y-Axis in the plane YX
     */
    YX,       
    /**
     *  Y-Axis in the plane YZ
     */
    YZ,       
    /**
     *  Z-Axis in the plane ZX
     */
    ZX,       
    /**
     *  Z-Axis in the plane ZY
     */
    ZY        
  } ;



  /*----------------------------------------------------------------------------*/


 PoINTERNAL public:
  static void initClass() ;
	static void exitClass() ;
  
 protected:
  PoCartesianAxis() ;
  // Constructor

  virtual ~PoCartesianAxis() ;
  // Destructor

  // Methods
  virtual SbBool setUpConnections(SbBool onOff, SbBool doItAlways = FALSE) ;
  virtual void   setDefaultOnNonWritingFields() ;

  // Compute axis tranformation
  void computeTransfo(const SbVec3f &refPoint, SoMatrixTransform *transfo, 
                      float &deltaX, float &deltaY) ;
  
 private:
  // Sensors
  FieldSensorList fieldSensorList ;
  
  // List of fields defined in this class
  SoFieldList     fieldList ;
} ;

/*----------------------------------------------------------------------------*/

#endif /* _PO_CARTESIAN_AXIS_ */

