/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/

#ifndef  _PO_CIRCLE_ARC_
#define  _PO_CIRCLE_ARC_

#include <MeshViz/graph/PoGraphMaster.h>

/**
 * @DTEXT  Abstract class for 2D circle arc representation.
 * 
 * @ingroup GraphMisc
 * 
 * @DESCRIPTION
 * 
 */
class MESHVIZ_API PoCircleArc : public PoGraphMaster {

  SO_KIT_HEADER(PoCircleArc) ;
  
  /* Define fields for new parts */
  SO_KIT_CATALOG_ENTRY_HEADER(circleArc) ;
  

 public:

  

  /**
   *  Type of the circle arc
   */
  enum ArcType {
    /**
     *  The arc is opened.
     */
    OPENED,       
    /**
     *  The arc is closed by its extremities.
     */
    END_CLOSE,    
    /**
     *  The arc is closed by the circle center.
     */
    CENTER_CLOSE  
  } ;

  /**
   * Indicates if the arc is opened, closed by its extremities or closed by its center.
   */
  SoSFEnum arcType ;

  /*----------------------------------------------------------------------------*/
 PoINTERNAL public:
  static void initClass() ;
	static void exitClass() ;

 protected:
  // Conctructor
  PoCircleArc() ;

  // Destructor
  virtual ~PoCircleArc() ;

  // Methods
  virtual void   setDefaultOnNonWritingFields() ;
  virtual SbBool setUpConnections(SbBool onOff, SbBool doItAlways = FALSE) ;
 private:
  // Sensors
  FieldSensorList fieldSensorList ;
  
  // List of fields defined in this class
  SoFieldList     fieldList ;
} ;

/*----------------------------------------------------------------------------*/

#endif /*  _PO_CIRCLE_ARC_ */

