/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/

#ifndef  _PO_BEVEL_EDGE_
#define  _PO_BEVEL_EDGE_

#include <Inventor/fields/SoSFFloat.h>
#include <Inventor/fields/SoSFEnum.h>
#include <Inventor/fields/SoSFBool.h>

#include <MeshViz/nodes/PoNode.h>

/**
 * @DTEXT  Node to define the beveled edge values.
 * 
 * @ingroup GraphProperty
 * 
 * @DESCRIPTION
 *    This node defines the current values to bevel edges of all subsequent
 *    MeshViz representations inhering from PoChart.
 *    The way in which edges are beveled is defined by a radius to indicate the
 *    size of the bevel and by a bevelAngle to indicate the minimum angle between
 *    two adjacent face normals required to bevel the edge common to these 
 *    two faces.
 * 
 * 
 * @FILE_FORMAT_DEFAULT
 *    PoBevelEdge {
 *    @TABLE_FILE_FORMAT
 *       @TR on @TD TRUE
 *       @TR radius @TD 0.05
 *       @TR radiusFlag @TD PERCENTAGE_RADIUS
 *       @TR bevelAngle @TD 0.5
 *    @TABLE_END
 *    }
 * 
 * 
 */
class MESHVIZ_API PoBevelEdge : public PoNode {
  
  SO_NODE_HEADER(PoBevelEdge) ;
  

 public:

  /**
   *  Radius Type.
   */
  enum RadiusFlag {
    ABSOLUTE_RADIUS,
    PERCENTAGE_RADIUS
  } ;

  /* Fields */

  /**
   * Activate/Desactivate bevel attributes.
   */
  SoSFBool  on ;

  /**
   * Indicates the radius of the bevel.
   */
  SoSFFloat radius ;

  /**
   * Defines the interpretation of the field radius. 
   * If radiusFlag == ABSOLUTE_RADIUS, the radius value is absolute.
   * If radiusFlag == PERCENTAGE_RADIUS, the field radius is a percentage (0. <= radius <= 1.),
   * the real radius corresponding is max * radius, where max is the maximun length of all 
   * the edges of the current shape to be beveled.
   */
  SoSFEnum  radiusFlag ;

  /**
   * Indicates the minimum angle (in radians) between two adjacent face normals required
   * to bevel the edge common to these two faces.
   */
  SoSFFloat bevelAngle ;

  /**
   * Constructor.
   */
  PoBevelEdge() ;

  /*----------------------------------------------------------------------------*/

  
 SoEXTENDER public:
  virtual void  doAction(SoAction *action) ;
  
 SoINTERNAL public:
  static void initClass() ;
	static void exitClass() ;
  
 protected:
  virtual ~PoBevelEdge() ;
  
} ;
/*----------------------------------------------------------------------------*/

#endif /* _PO_BEVEL_EDGE_  */

