/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2018 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/

#ifndef  _PO_INTERVAL_CELL_FILTER_
#define  _PO_INTERVAL_CELL_FILTER_

#include <Inventor/fields/SoSFFloat.h>
#include <Inventor/fields/SoSFBool.h>
#include <MeshViz/nodes/PoCellFilter.h>

class SoFieldSensor ;

/**
 * @DTEXT Node class to define a filter of cells.
 * 
 * @ingroup MeshProperty
 * 
 * @DESCRIPTION
 * 
 * This filter accepts only those cells whose value is either inside or outside a float interval.
 *
 */
class MESHVIZ_API PoIntervalCellFilter : public PoCellFilter {
  SO_NODE_HEADER(PoIntervalCellFilter) ;

 public:

  PoIntervalCellFilter() ;

  /**
   * Specifies the min limit of the float interval.
   * 
   */
  SoSFFloat min;

  /**
   * Specifies the max limit of the float interval.
   */
  SoSFFloat max;

  /**
   * Specifies if accepted cells are those whose value is inside or outside the
   * interval ]min,max[.
   * @param in If TRUE, the cell is accepted if min < v && v < max, where v is the value of cell
   * to be checked.
   * @param in If FALSE, the cell is accepted if v <= min || max <= v, where v is the value of cell
   * to be checked.
   * 
   */
  SoSFBool  in;

  /**
   * See PoCellFilter::acceptCell(). 
   * @param cell_index The cell index is ignored by this filter as it checks only 
   * the value of the cell.
   * @param cell_value the value of this cell.
   */
  SbBool acceptCell(int cell_index, float cell_value) const;

  /*----------------------------------------------------------------------------*/
 SoINTERNAL public:
  static void initClass() ;
	static void exitClass() ;

 protected:
  virtual ~PoIntervalCellFilter() ;


 private:
  static void changeCB(void *data, SoSensor *) ;

  SbBool        m_filterChanged;
  SoFieldSensor *m_minSensor;
  SoFieldSensor *m_maxSensor;
  SoFieldSensor *m_inSensor;
} ;

/*----------------------------------------------------------------------------*/

#endif /* _PO_INTERVAL_CELL_FILTER_ */


