/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2019 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/

#ifndef  _PO_NODE_
#define  _PO_NODE_

#include <Inventor/nodes/SoNode.h>

/**
 * @DTEXT  Abstract base class for all MeshViz nodes.
 * 
 * @ingroup MeshVizMisc
 * 
 * @DESCRIPTION
 *   This node is the abstract base class for all MeshViz nodes.
 * 
 * [OIVJAVA-WRAPPER-CLASS DERIVABLE]
 */
class MESHVIZ_API PoNode : public SoNode {
  SO_NODE_ABSTRACT_HEADER(PoNode) ;

 SoEXTENDER public:
  virtual void  doAction(SoAction *action) =0;
  virtual void  callback(SoCallbackAction *action) ;
  virtual void  GLRender(SoGLRenderAction *action) ;
  virtual void  getBoundingBox(SoGetBoundingBoxAction *action) ;
  virtual void  getMatrix(SoGetMatrixAction *action) ;
  virtual void  handleEvent(SoHandleEventAction *action) ;
  virtual void  pick(SoPickAction *action) ;
  virtual void  search(SoSearchAction *action) ;
  virtual void  write(SoWriteAction *action) ;
  virtual void getPrimitiveCount(SoGetPrimitiveCountAction *action);


  /*----------------------------------------------------------------------------*/
  
 SoINTERNAL public:
  static void initClass() ;
	static void exitClass() ;
  static void initClasses() ;
	static void exitClasses() ;
  
 protected:
  PoNode() ;
  virtual ~PoNode() ;   
} ; 
/*----------------------------------------------------------------------------*/

#endif /* _PO_NODE_ */

