/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/

#ifndef  _PO_REGULARCARTESIANGRID2D_
#define  _PO_REGULARCARTESIANGRID2D_

#include <MeshViz/nodes/PoMeshProperty.h>
#include <MeshViz/fields/PoSFRegularCartesianGrid2D.h>

class PbMesh;

/**
 * @DTEXT  Inventor node defining a mesh of type PbRegularCartesianGrid2D.
 * 
 * @ingroup MeshProperty
 * 
 * @DESCRIPTION
 * 
 */
class MESHVIZ_API PoRegularCartesianGrid2D : public PoMeshProperty {

  SO_NODE_HEADER(PoRegularCartesianGrid2D) ;
  

 public:



  /**
   * Constructor.
   */
  PoRegularCartesianGrid2D() ;

  /**
   * Field containing a mesh of type PbRegularCartesianGrid2D.
   */
  PoSFRegularCartesianGrid2D mesh;

  /**
   * Gets the instance of the class PbRegularCartesianGrid2D contained by the field mesh.
   */
  const PbMesh* getMesh() const { return (const PbMesh*)&mesh.getValue();};

  /**
   * Convenience method to change the geometry of the mesh. 
   * See also PbRegularCartesianGrid2D::setGeometry().
   */
  void setGeometry(int num_x, int num_y, 
                   float x_min, float y_min, 
                   float x_max, float y_max, 
                   const float *zn=NULL);

  /*----------------------------------------------------------------------------*/
 SoEXTENDER public:
  virtual void  doAction(SoAction *action) ;

 SoINTERNAL public:
  static void initClass() ;
	static void exitClass() ;
  
 protected:
  const PoSFMesh* getSFieldMesh() const { return &mesh; }
  virtual ~PoRegularCartesianGrid2D() ;

 private:

} ; 
/*----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------*/
inline void 
PoRegularCartesianGrid2D::setGeometry(int num_x, int num_y, 
                                      float x_min, float y_min, 
                                      float x_max, float y_max, 
                                      const float *zn)
{
  mesh.setGeometry(num_x, num_y,  
                   x_min, y_min, 
                   x_max, y_max, 
                   zn);
}

#endif /* _PO_REGULARCARTESIANGRID2D_  */

