/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/

#ifndef  _PO_REGULARMESH1D_
#define  _PO_REGULARMESH1D_

#include <MeshViz/nodes/PoMeshProperty.h>
#include <MeshViz/fields/PoSFRegularMesh1D.h>

class PbMesh;

/**
 * @DTEXT  Inventor node defining a mesh of type PbRegularMesh1D.
 * 
 * @ingroup GraphProperty
 * 
 * @DESCRIPTION
 * 
 */
class MESHVIZ_API PoRegularMesh1D : public PoMeshProperty {

  SO_NODE_HEADER(PoRegularMesh1D) ;
  

 public:



  /**
   * Constructor.
   */
  PoRegularMesh1D() ;

  /**
   * Field containing a mesh of type PbRegularMesh1D.
   */
  PoSFRegularMesh1D mesh;

  /**
   * Gets the instance of the class PbRegularMesh1D contained by the field mesh.
   */
  const PbMesh* getMesh() const { return (const PbMesh*)&mesh.getValue();};

  /**
   * Convenience method to change the geometry of the mesh. See also
   * PbRegularMesh1D::setGeometry().
   */
  void setGeometry(int numX, float xmin, float xmax);

  /*----------------------------------------------------------------------------*/
 SoEXTENDER public:
  virtual void  doAction(SoAction *action) ;

 SoINTERNAL public:
  static void initClass() ;
	static void exitClass() ;
  
 protected:
  const PoSFMesh* getSFieldMesh() const { return &mesh; }
  virtual ~PoRegularMesh1D() ;

} ; 
/*----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------*/
inline void 
PoRegularMesh1D::setGeometry(int numX, float xmin, float xmax)
{
  mesh.setGeometry(numX, xmin, xmax);
}

#endif /* _PO_REGULARMESH1D_  */

