/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2017 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
#ifndef _MIABSTRACTMETHODERROR_H
#define _MIABSTRACTMETHODERROR_H

#include <Inventor/STL/iostream>
#include <Inventor/STL/sstream>
#include <Inventor/STL/string>

/**
 * @DTEXT Exception handler for MeshViz XLM.
 * 
 * @ingroup MeshVizXLM
 * 
 * @DESCRIPTION This class is used when throwing exceptions in methods that were not
 *              (but should have been) overloaded by the application. 
 *
 */
class MiAbstractMethodError : public std::exception
{
public:
  /**
  * Constructor
  */
  MiAbstractMethodError(std::string methodName)
  {
    std::stringstream errorStream;
    errorStream << "method " << methodName << " is not implemented or not consistent!";
    m_error = errorStream.str();
  }

  /**
  * Returns the string containing the name of the method which is not overloaded.
  */
  std::string getError() 
  { 
    return m_error;
  }
  
  /**
  * Returns the c-string containing the name of the method which is not overloaded.
  */
  virtual const char* what() const throw ()
  {
    return m_error.c_str();
  }

  ~MiAbstractMethodError () throw ()
  {
  }

protected: 
  std::string m_error;
 
};

#endif


