/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2017 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
#ifndef  _MIBASEEXTRACTOR_H
#define  _MIBASEEXTRACTOR_H

#include <MeshVizXLM/MxMeshVizXLM.h>
#include <MeshVizXLM/extractors/MiExtractorCallback.h>

/**
* @DTEXT  Abstract base class for all extractor interfaces.
*
* @ingroup MeshVizXLM_Extract 
*
* @DESCRIPTION
* All extractor interface classes are derived from this one and
* must implement the setExtractorCallback method.
*/

class MESHVIZXLM_EXTR_API MiBaseExtractor 
{
public:
  virtual ~MiBaseExtractor() {}

  /**
  * Set the user defined extractor callback which will be called before each extraction, 
  * during each extraction and after each extraction. Remove callback from the extractor if
  * extractorCallback is NULL.
  */
  virtual void setExtractorCallback(MiExtractorCallback* extractorCallback) = 0;

  SoDEPRECATED_METHOD(9400,"Use setExtractorCallback(MiExtractorCallback*) instead")
  virtual void setExtractorCallback(MiExtractorCallback& extractorCallback) 
  {
    setExtractorCallback(&extractorCallback);
  }

};

#endif /* _MIBASEEXTRACTOR_H */


