/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2017 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
#ifndef  _MIBASELOGICALSLICEEXTRACT_H
#define  _MIBASELOGICALSLICEEXTRACT_H

#include <MeshVizXLM/mesh/MiMesh.h>

#ifdef _WIN32
#  pragma warning( push )
#  pragma warning(disable:4996)
#endif

/**
* @ingroup MeshVizXLM_Extract_Logicalslice
* Slice axis enum used to define the logical slice
*/

class SoDEPRECATED_CLASS(9300,"Use MiMesh::Dimension instead.") SliceAxis { 
public:
  static const MiMesh::Dimension SLICE_I = MiMesh::DIMENSION_I; /**< Slice at I constant */ 
  static const MiMesh::Dimension SLICE_J = MiMesh::DIMENSION_J; /**< Slice at J constant */ 
  static const MiMesh::Dimension SLICE_K = MiMesh::DIMENSION_K; /**< Slice at K constant */ 

  // constructors + operators
  SliceAxis() : m_axis(MiMesh::DIMENSION_I) {}
  SliceAxis(MiMesh::Dimension a) : m_axis(a) {}
  SliceAxis(int a) : m_axis((MiMesh::Dimension)a) {}
  SliceAxis(size_t a) : m_axis((MiMesh::Dimension)a) {}
  operator MiMesh::Dimension() const { return m_axis; }

private:
  MiMesh::Dimension m_axis;

};

SoDEPRECATED_METHOD(9300, "Use MiMesh::Dimension instead.")
static const MiMesh::Dimension SLICE_I = MiMesh::DIMENSION_I; /**< Slice at I constant */ 

SoDEPRECATED_METHOD(9300, "Use MiMesh::Dimension instead.")
static const MiMesh::Dimension SLICE_J = MiMesh::DIMENSION_J; /**< Slice at J constant */

SoDEPRECATED_METHOD(9300, "Use MiMesh::Dimension instead.")
static const MiMesh::Dimension SLICE_K = MiMesh::DIMENSION_K; /**< Slice at K constant */

#ifdef _WIN32
#  pragma warning( pop )
#endif

#endif /* _MIBASELOGICALSLICEEXTRACT_H */


