/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2017 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (Feb 2012)
**=======================================================================*/
#ifndef  _MiClipPointExtract_h
#define  _MiClipPointExtract_h

#include <MeshVizXLM/extractors/MiBaseExtractor.h>
#include <MeshVizXLM/mesh/data/MiDataSetIj.h>
#include <MeshVizXLM/extrmesh/data/MeXDataSetI.h>
#include <MeshVizXLM/extrmesh/MeXPointMeshCurvilinear.h>

class MiCellFilterI;
class MiLineMeshRegular;
class MiLineMeshCurvilinear;
class MiLineMeshUnstructured;
class MiTessellator;

/** 
 * @DTEXT Clip point extractor for all line meshes
 * 
 * @ingroup MeshVizXLM_Extract_Clip
 * 
 * @DESCRIPTION A clip point is the intersection of a given plane with a line mesh.
 * The extracted points are returned as a curvilinear point mesh.
 * 
 * @see MeXPointMeshCurvilinear
 */
class MESHVIZXLM_EXTR_API MiClipPointExtract : virtual public MiBaseExtractor
{
public:

  //@{
  /**
  * @copydoc MiCellExtractIjk::getNewInstance()
  */ 
  static MiClipPointExtract* getNewInstance(const MiLineMeshRegular& mesh, bool parallel = true, MiTessellator* tessellator=NULL);
  static MiClipPointExtract* getNewInstance(const MiLineMeshCurvilinear& mesh, bool parallel = true, MiTessellator* tessellator=NULL);
  static MiClipPointExtract* getNewInstance(const MiLineMeshUnstructured& mesh, bool parallel = true, MiTessellator* tessellator=NULL);
  //@}

  /**
  * Builds the point mesh intersecting the line mesh and the given plane.
  * 
  * @param normal Vector normal to the plane 
  * @param distance Position of the plane relatively to the origin along the normal
  * @param cellFilter The cell filter object. 
  * @return A point mesh representing the extracted clipped points
  */
  virtual const MeXPointMeshCurvilinear& extractPoints(const MbVec3<double>& normal, double distance, const MiCellFilterI* cellFilter=NULL) = 0;

  /**
  * Extracts a scalar set from the line mesh. The scalars are mapped onto the 
  * current extracted clip points. 
  *
  * @param inputSet the input scalar set defined on the line mesh
  * @return the output scalar set defined on the resulting mesh
  */
  virtual const MeXScalardSetI& extractScalarSet(const MiScalardSetI& inputSet) = 0;

  /**
  * Extracts a vector set from the line mesh. The vectors are mapped onto the 
  * current extracted clip points.
  *
  * @param inputSet the input vec3 set defined on the line mesh
  * @return the output scalar set defined on the resulting mesh
  */
  virtual const MeXVec3dSetI& extractVec3Set(const MiVec3dSetI& inputSet) = 0;

  /**
  * Returns the result of the extraction as a point mesh.
  */
  virtual const MeXPointMeshCurvilinear& getExtract() const = 0;

};

#endif 


