/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2017 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
#ifndef  _MiFenceSliceExtractIjk_h
#define  _MiFenceSliceExtractIjk_h

#include <MeshVizXLM/extractors/MiBaseExtractor.h>
#include <MeshVizXLM/mesh/data/MiDataSetIjk.h>
#include <MeshVizXLM/extrmesh/data/MeXDataSetI.h>
#include <MeshVizXLM/extrmesh/MeXSurfaceMeshUnstructured.h>

#include <MeshVizXLM/mesh/MiVolumeMeshRegular.h>
#include <MeshVizXLM/mesh/MiVolumeMeshRectilinear.h>
#include <MeshVizXLM/mesh/MiVolumeMeshCurvilinear.h>
#include <MeshVizXLM/mesh/MiVolumeMeshVertexHexahedronIjk.h>
class MiCellFilterIjk;
class MiTessellator;

/**
 * @DTEXT Fence slice extractor for structured volume meshes
 * 
 * @ingroup MeshVizXLM_Extract_Slice
 * 
 * @DESCRIPTION
 *  A fence slice is an unstructured surface mesh defined by the intersection of several arbitrary planes (the fences)
 *  with a volume mesh. These fences are defined by a polyline and a direction. Each segment of the polyline is
 *  extruded along the direction to form a clipped plane slice. Thus, each fence goes through a segment of the polyline.
 *  Each plane slice is clipped by the extrusion of the 2 endpoints of each segment in the direction.
 * The extracted fence slice is an unstructured surface.
 * 
 * @SEE_ALSO
 * MoMeshFenceSlice, MiFenceSliceExtractUnstructured, MiFenceSliceExtractHexahedronIjk
 */
class MESHVIZXLM_EXTR_API MiFenceSliceExtractIjk : virtual public MiBaseExtractor
{
public:
  virtual ~MiFenceSliceExtractIjk() {}

  /**
  * @copydoc MiCellExtractIjk::getNewInstance()
  */ 
  static MiFenceSliceExtractIjk* getNewInstance(const MiVolumeMeshRegular& mesh, bool parallel = true, MiTessellator* tessellator=NULL);
  static MiFenceSliceExtractIjk* getNewInstance(const MiVolumeMeshRectilinear& mesh, bool parallel = true, MiTessellator* tessellator=NULL);
  static MiFenceSliceExtractIjk* getNewInstance(const MiVolumeMeshCurvilinear& mesh, bool parallel = true, MiTessellator* tessellator=NULL);
  static MiFenceSliceExtractIjk* getNewInstance(const MiVolumeMeshVertexHexahedronIjk& mesh, bool parallel = true, MiTessellator* tessellator=NULL);

  /**
  * Builds the topology and geometry of a fence slice intersecting the volume mesh.
  * 
  * @return the fence slice extracted as an unstructured surface mesh.
  * @param direction vector defining the direction of the fences
  * @param polyline set of points defining the position of the fences
  * @param cellFilter The cell filter object. 
  * @return An unstructured surface mesh representing the fence slice
  */
  virtual const MeXSurfaceMeshUnstructured& extract(const MbVec3d& direction, const std::vector<MbVec3d>& polyline, const MiCellFilterIjk* cellFilter=NULL) = 0;
  
  /**
  * Extracts a scalar set from the volume mesh. The scalars are mapped onto the 
  * current extracted fence slice.
  *
  * @param inputSet the input scalar set defined on the volume mesh
  * @return the output scalar set defined on the latest extracted mesh
  */
  virtual const MeXScalardSetI& extractScalarSet(const MiScalardSetIjk& inputSet) = 0;

  /**
  * Extracts a vector set from the volume mesh. The vectors are mapped onto the 
  * current extracted fence slice.
  *
  * @param inputSet the input vector set defined on the volume mesh
  * @return the output vector set defined on the latest extracted mesh
  */
  virtual const MeXVec3dSetI& extractVec3Set(const MiVec3dSetIjk& inputSet) = 0;

  /**
  * @copydoc MiCellExtractIjk::getExtract()
  */
  virtual const MeXSurfaceMeshUnstructured& getExtract() const = 0;

};

#endif 


