/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2017 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
#ifndef  _MiFenceSliceExtractUnstructured_h
#define  _MiFenceSliceExtractUnstructured_h

#include <MeshVizXLM/extractors/MiBaseExtractor.h>
#include <MeshVizXLM/mesh/MiVolumeMeshUnstructured.h>
#include <MeshVizXLM/extrmesh/data/MeXDataSetI.h>
#include <MeshVizXLM/extrmesh/MeXSurfaceMeshUnstructured.h>

class MiCellFilterI;
class MiTessellator;
class MeXLineMeshUnstructured;

/**
 * @DTEXT Fence slice extractor for unstructured volume meshes
 * 
 * @ingroup MeshVizXLM_Extract_Slice
 * 
 * @DESCRIPTION
 *  A fence slice is an unstructured surface mesh defined by the intersection of several arbitrary planes (the fences)
 *  with a volume mesh. These fences are defined by a polyline and a direction. Each segment of the polyline is
 *  extruded along the direction to form a clipped plane slice. Thus, each fence goes through a segment of the polyline.
 *  Each plane slice is clipped by the extrusion of the 2 endpoints of each segment in the direction.
 * The extracted fence slice is an unstructured surface.
 * 
 * @SEE_ALSO
 * MoMeshFenceSlice, MiFenceSliceExtractIjk, MiFenceSliceExtractHexahedronIjk
 * 
 */
class MESHVIZXLM_EXTR_API MiFenceSliceExtractUnstructured : virtual public MiBaseExtractor
{
public:
  virtual ~MiFenceSliceExtractUnstructured() {}

  /**
  * @copydoc MiCellExtractIjk::getNewInstance()
  */ 
  static MiFenceSliceExtractUnstructured* getNewInstance(const MiVolumeMeshUnstructured& mesh, bool parallel = true, MiTessellator* tessellator=NULL);

  /**
  * @copydoc MiFenceSliceExtractIjk::extract()
  */ 
  virtual const MeXSurfaceMeshUnstructured& extract(const MbVec3d& direction, const std::vector<MbVec3d>& polyline, const MiCellFilterI* cellFilter=NULL) = 0;
  
  /**
  * Extracts a scalar set from the volume mesh. The scalars are mapped onto the 
  * current extracted fence slice referring to either the line mesh or the surface mesh depending on
  * whether extract() or extractLine() was last called.
  *
  * @param inputSet the input scalar set defined on the volume mesh
  * @return the output scalar set defined on the latest extracted mesh
  */
  virtual const MeXScalardSetI& extractScalarSet(const MiScalardSetI& inputSet) = 0;

  /**
  * Extracts a vector set from the volume mesh. The vectors are mapped onto the 
  * current extracted fence slice referring to either the line mesh or the surface mesh depending on
  * whether extractSlice() or extractLineSlice() was last called.
  *
  * @param inputSet the input vector set defined on the volume mesh
  * @return the output vector set defined on the latest extracted mesh
  */
  virtual const MeXVec3dSetI& extractVec3Set(const MiVec3dSetI& inputSet) = 0;

  /**
  * @copydoc MiCellExtractIjk::getExtract()
  */
  virtual const MeXSurfaceMeshUnstructured& getExtract() const = 0;

};

#endif 


