/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2018 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
#ifndef  _MiGridPlaneSliceExtractUnstructured_H
#define  _MiGridPlaneSliceExtractUnstructured_H

#include <MeshVizXLM/extractors/MiBaseExtractor.h>
#include <MeshVizXLM/mesh/data/MiDataSetI.h>
#include <MeshVizXLM/extrmesh/data/MeXDataSetIj.h>

#include <MeshVizXLM/mesh/MiVolumeMeshUnstructured.h>
#include <MeshVizXLM/extrmesh/MeXSurfaceMeshCurvilinear.h>

#include <Inventor/STL/vector>

class MiCellFilterI;
class MiTessellator;

/**
 * @DTEXT Grid plane slice extractor on unstructured volume meshes
 * 
 * @ingroup MeshVizXLM_Extract_Slice
 * 
 * @DESCRIPTION This extractor is similar to the plane slice extractor except that it creates a structured mesh and probes the 
 * input volume to compute the values at the surface nodes and cells (See MiPointProbeUnstructured for settings).
 * The grid created by this extractor is computed so that it encloses completely the cross section of the input volume mesh marking as dead the
 * cells outside the volume.
 * 
 */

class MESHVIZXLM_EXTR_API MiGridPlaneSliceExtractUnstructured : virtual public MiBaseExtractor
{
public:
    
  virtual ~MiGridPlaneSliceExtractUnstructured() {}

  /**
  * @copydoc MiInterpolatedLogicalSliceExtract::getNewInstance()
  */ 
  static MiGridPlaneSliceExtractUnstructured* getNewInstance(const MiVolumeMeshUnstructured& mesh, bool parallel = true, MiTessellator* tessellator = NULL);

  /**
  * @copydoc MiGridPlaneSliceExtractIjk::extractGrid()
  */ 
  virtual const MeXSurfaceMeshCurvilinear&
  extractGrid(const MbVec3<double>& normal, double distance, double step, const MiCellFilterI* cellFilter=NULL) = 0;
 
  /**
  * Extracts a PER_NODE scalar set from the volume mesh. The scalars are mapped onto the 
  * current extracted grid. 
  * Even if the binding of the input scalar set is PER_CELL, this extractor cannot produce a PER_CELL extract
  * because it uses the probing mechanism at each grid plane node to extract values and so does not contain
  * PER_CELL values.
  *
  * @param inputSet the input scalar set defined on the volume mesh
  * @return the output scalar set defined on the resulting grid volume mesh
  */
  virtual const MeXScalardSetIj& extractScalarSet(const MiScalardSetI& inputSet) = 0;

  /**
  * Extracts a PER_NODE vector set from the volume mesh. The vectors are mapped onto the 
  * current extracted grid. 
  * Even if the binding of the input vector set is PER_CELL, this extractor cannot produce a PER_CELL extract
  * because it uses the probing mechanism at each grid plane node to extract values and so does not contain
  * PER_CELL values.
  *
  * @param inputSet the input vec3 set defined on the volume mesh
  * @return the output scalar set defined on the resulting grid volume mesh
  */
  virtual const MeXVec3dSetIj& extractVec3Set(const MiVec3dSetI& inputSet) = 0;

  /**
  * @copydoc MiCellExtractIjk::getExtract()
  */
  virtual const MeXSurfaceMeshCurvilinear& getExtract() const = 0;

};

#endif /* _MiGridPlaneSliceExtractUnstructured_H */


