/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2018 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
#ifndef  _MIINTERPOLATEDLOGICALSLICEEXTRACT_H
#define  _MIINTERPOLATEDLOGICALSLICEEXTRACT_H

#include <MeshVizXLM/extractors/MiBaseExtractor.h>
#include <MeshVizXLM/extractors/MiBaseLogicalSliceExtract.h>
#include <MeshVizXLM/extrmesh/MeXSurfaceMeshUnstructured.h>
#include <MeshVizXLM/extrmesh/data/MeXDataSetI.h>
#include <MeshVizXLM/mesh/data/MiDataSetIjk.h>

class MiTessellator;
class MiCellFilterIjk;
class MiVolumeMeshRegular;
class MiVolumeMeshRectilinear;
class MiVolumeMeshCurvilinear;

/**
 * @DTEXT Interpolated logical slice extractor for structured volume meshes
 * 
 * @ingroup MeshVizXLM_Extract_Logicalslice
 * 
 * @DESCRIPTION An interpolated logical slice is similar to a logical slice except that instead of 
 * displaying the slice only on the side of the cells, it can interpolate a slice inside cells. 
 * This is done by providing a floating point value representing the offset along the cell axis.
 * 
 */
class MESHVIZXLM_EXTR_API MiInterpolatedLogicalSliceExtract : virtual public MiBaseExtractor
{
public:
  virtual ~MiInterpolatedLogicalSliceExtract() {};

  //@{
  /**
  * Factory method returning a new instance of a class implementing this abstract class.
  * @param mesh The input mesh 
  * @param parallel When true, tries to create an extract module using a parallel algorithm to speed up the extraction. 
  * @param tessellator The tessellator object used for tessellating non linear cells (quadratic,...).
  * @note Only some of the extraction algorithms have a parallel implementation.
  */ 
  static MiInterpolatedLogicalSliceExtract* getNewInstance(const MiVolumeMeshRegular& mesh, bool parallel = true, MiTessellator* tessellator = NULL);
  static MiInterpolatedLogicalSliceExtract* getNewInstance(const MiVolumeMeshCurvilinear& mesh, bool parallel = true, MiTessellator* tessellator = NULL);
  static MiInterpolatedLogicalSliceExtract* getNewInstance(const MiVolumeMeshRectilinear& mesh, bool parallel = true, MiTessellator* tessellator = NULL);
  //@}

  /**
  * Builds the topology and geometry of the Interpolated Logical Slice at the given value 
  * along the given slice axis.
  */
  virtual const MeXSurfaceMeshUnstructured& extractInterpolatedLogicalSlice(MiMesh::Dimension, double sliceValue, const MiCellFilterIjk* cellFilterIjk=NULL) = 0;
  
 /**
  * Extracts a scalar set from the volume mesh. The scalars are mapped onto the 
  * current extracted interpolated logical slice. 
  *
  * @param inputSet the input scalar set defined on the volume mesh
  * @return the output scalar set defined on the resulting surface mesh. 
  */
  virtual const MeXScalardSetI& extractScalarSet(const MiScalardSetIjk& inputSet) = 0;

  /**
  * Extracts a vector set from the volume mesh. The vectors are mapped onto the 
  * current extracted logical slice. 
  *
  * @param inputSet the input vector set defined on the volume mesh
  * @return the output scalar set defined on the resulting surface mesh
  */
  virtual const MeXVec3dSetI& extractVec3Set(const MiVec3dSetIjk& inputSet) = 0;

  /**
  * Returns the result of the extraction. 
  * @note This method returns the same object returned by extractInterpolatedLogicalSlice without recomputing a new slice.
  * This is useful to avoid to have to store the extracted surface in an intermediate object.
  */
  virtual const MeXSurfaceMeshUnstructured& getExtract() const = 0;

};

#endif /* _MIINTERPOLATEDLOGICALSLICEEXTRACT_H */


