/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2019 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
#ifndef  _MIISOLINELINEEXTRACTIJ_H
#define  _MIISOLINELINEEXTRACTIJ_H

#include <MeshVizXLM/extrmesh/MeXLineMeshUnstructured.h>
#include <MeshVizXLM/extrmesh/data/MeXDataSetI.h>
#include <MeshVizXLM/mesh/data/MiDataSetIj.h>

class MiCellFilterIj;
class MiSurfaceMeshRegular;
class MiSurfaceMeshRectilinear;
class MiSurfaceMeshCurvilinear;

#include <MeshVizXLM/extractors/MiBaseExtractor.h>
#include <Inventor/STL/vector>

/**
 * @DTEXT Isoline extractor for structured surface meshes.
 * 
 * @ingroup MeshVizXLM_Extract_Isoline
 * 
 * @DESCRIPTION Builds a list of lines containing the extracted isolines for the given data set at the given values.
 * 
 * 
 */
class MESHVIZXLM_EXTR_API MiIsolineExtractIj : virtual public MiBaseExtractor
{
public:
  virtual ~MiIsolineExtractIj() {}

  //@{
  /**
  * Factory method returning a new instance of a class implementing this abstract class.
  * @param mesh The input mesh 
  * @param parallel When true, tries to create an extract module using a parallel algorithm to speed up the extraction. 
  * @note Only some of the extraction algorithms have a parallel implementation.
  */ 
  static MiIsolineExtractIj* getNewInstance(const MiSurfaceMeshRegular& mesh, bool parallel = true);
  static MiIsolineExtractIj* getNewInstance(const MiSurfaceMeshRectilinear& mesh, bool parallel = true);
  static MiIsolineExtractIj* getNewInstance(const MiSurfaceMeshCurvilinear& mesh, bool parallel = true);
  //@}

 /**
  * Builds the isolines of the given isovalues in the given dataset.
  * @param isovalueList List of values for which an isoline must be computed
  * @param dataSet The input data set used to compute isovalues from
  * @param cellFilter The cell filter
  * @return the output set of isolines
  */
  virtual const std::vector<const MeXLineMeshUnstructured*>&
  extractIsovalue(std::vector<double>& isovalueList, const MiScalardSetIj& dataSet, 
                  const MiCellFilterIj* cellFilter=NULL) = 0;
  /**
  * Computes a scalar set on the extracted isolines.
  * @param inputSet the input scalar set defined on the surface mesh
  * @return the output scalar set defined on the resulting isoline mesh
  */
  virtual const std::vector< const MeXScalardSetI* >& extractScalarSet(const MiScalardSetIj& inputSet) =0;

  /**
  * Computes a vector set on the extracted isolines.
  * @param inputSet the input vector set defined on the surface mesh
  * @return the output vector set defined on the resulting isoline mesh
  */
  virtual const std::vector< const MeXVec3dSetI* >& extractVec3Set(const MiVec3dSetIj& inputSet) = 0;

  /**
  * @copydoc MiCellExtractIjk::getExtract()
  */
  virtual const std::vector<const MeXLineMeshUnstructured*>& getExtract() const = 0;

};

#endif /* _MIISOLINEEXTRACT_H */

