/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2024 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
#ifndef  _MIISOSURFEXTRACTREGULAR_H
#define  _MIISOSURFEXTRACTREGULAR_H

#include <MeshVizXLM/mesh/data/MiDataSetIjk.h>
#include <MeshVizXLM/extrmesh/data/MeXDataSetI.h>
#include <MeshVizXLM/extractors/MiBaseExtractor.h>
#include <MeshVizXLM/extrmesh/MeXSurfaceMeshUnstructured.h>

class MiCellFilterIjk;
class MiVolumeMeshRegular;
class MiVolumeMeshCurvilinear;
class MiVolumeMeshRectilinear;
class MiVolumeMeshVertexHexahedronIjk;
class MiTessellator;

/**
 * @DTEXT Isosurface extractor for structured volume meshes
 *
 * @ingroup MeshVizXLM_Extract_Isosurf
 *
 * @DESCRIPTION Builds the isosurface of the given isovalue in the given dataset.
 *
 */
class MESHVIZXLM_EXTR_API MiIsosurfExtractIjk : virtual public MiBaseExtractor
{
public:
  virtual ~MiIsosurfExtractIjk() {}

  //@{
  /**
   * @copydoc MiCellExtractIjk::getNewInstance()
   */ 
  static MiIsosurfExtractIjk* getNewInstance(const MiVolumeMeshRegular& mesh, bool parallel = true, MiTessellator* tessellator=NULL);
  static MiIsosurfExtractIjk* getNewInstance(const MiVolumeMeshCurvilinear& mesh, bool parallel = true, MiTessellator* tessellator=NULL);
  static MiIsosurfExtractIjk* getNewInstance(const MiVolumeMeshRectilinear& mesh, bool parallel = true, MiTessellator* tessellator=NULL);
  static MiIsosurfExtractIjk* getNewInstance(const MiVolumeMeshVertexHexahedronIjk& mesh, bool parallel = true, MiTessellator* tessellator=NULL);
  //@}

  /**
   * Builds the isosurface of the given isovalue in the given dataset as a surface mesh.
   * @note Memory requirement:
   * The extractIsovalue method allocates a block of memory.  The size (in bytes)
   * is the number of cells in the mesh.  For a large mesh this is a significant
   * amount of memory. For example, a mesh 2000 x 2000 x 2000 requires 8 giga-bytes
   * of memory to extract an isosurface.  Applications should use try/catch blocks
   * to handle the case where this memory allocation fails. Also note that this
   * memory is retained until the extractor is destroyed.
   * @note In the case of a dataset bound PER_CELL, it will be converted into
   * a new internal dataset bound PER_NODE and cached in the extractor.
   * @param isovalue Value for which an isosurface must be computed
   * @param dataSet The input data set used to compute the isovalue from.
   *                When extracting from a MiVolumeMeshVertexHexahedronIjk, this dataset must be bound PER_CELL,
   *                otherwise the extraction will thow a std::exception.
   * @param cellFilter The cell filter
   * @return The extracted isosurface
   */
  virtual const MeXSurfaceMeshUnstructured& extractIsovalue(double isovalue, const MiScalardSetIjk& dataSet, const MiCellFilterIjk* cellFilter=NULL) = 0;

  /**
   * Computes a scalar set on the extracted isosurface.
   * @param inputSet the input scalar set defined on the volume mesh
   *                 When extracting from a MiVolumeMeshVertexHexahedronIjk, this dataset must be bound PER_CELL,
   *                 otherwise the extraction will thow a std::exception.
   * @return the output scalar set defined on the resulting isosurface mesh
   */
  virtual const MeXScalardSetI& extractScalarSet(const MiScalardSetIjk& inputSet) = 0;

  /**
   * Computes a vector set on the extracted isosurface.
   * @param inputSet the input vec3 set defined on the volume mesh
   *                 When extracting from a MiVolumeMeshVertexHexahedronIjk, this dataset must be bound PER_CELL,
   *                 otherwise the extraction will thow a std::exception.
   * @return the output scalar set defined on the resulting isosurface mesh
   */
  virtual const MeXVec3dSetI& extractVec3Set(const MiVec3dSetIjk& inputSet) = 0;

  /**
   * @copydoc MiCellExtractIjk::getExtract()
   */
  virtual const MeXSurfaceMeshUnstructured& getExtract() const = 0;


} ;


#endif 


