/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2017 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
#ifndef  _MiLineCellExtractI_H
#define  _MiLineCellExtractI_H

#include <MeshVizXLM/mesh/data/MiDataSetI.h>
#include <MeshVizXLM/extractors/MiBaseExtractor.h>
#include <MeshVizXLM/extrmesh/data/MeXDataSetI.h>
#include <MeshVizXLM/extrmesh/MeXLineMeshUnstructured.h>

#include <Inventor/STL/vector>

class MiTessellator;
class MiCellFilterI;
class MiLineMeshRegular;
class MiLineMeshCurvilinear;

/** 
 * @DTEXT Cell extractor for line meshes
 * 
 * @ingroup MeshVizXLM_Extract_Cell
 * 
 * @DESCRIPTION Extracts a list of cells from the input line mesh 
 *              and builds a line mesh containing the extracted cells.
 * 
 */

class MESHVIZXLM_EXTR_API MiLineCellExtractI : virtual public MiBaseExtractor
{
public:
    
  virtual ~MiLineCellExtractI() {}

  /**
  * @copydoc MiCellExtractIjk::getNewInstance()
  */ 
  static MiLineCellExtractI* getNewInstance(const MiLineMeshRegular& mesh, bool parallel = true, MiTessellator* tessellator=NULL);
  static MiLineCellExtractI* getNewInstance(const MiLineMeshCurvilinear& mesh, bool parallel = true, MiTessellator* tessellator=NULL);

  /**
  * Create unstructured line meshes from the lines of the cells corresponding to the
  * given indices in the original line mesh. Cells are scaled according to the given
  * factor. @n
  * Shrinking: factor < 1 @n
  * Expanding: factor > 1
  */
  virtual const MeXLineMeshUnstructured&
  extractCell(const std::vector<size_t>& cellIndex, double factor, const MiCellFilterI* cellFilter=NULL) = 0;

  /**
  * Create unstructured line meshes from the lines of the cells in the entire line mesh.
  * Cells are scaled according to the given factor. @n
  * Shrinking: factor < 1 @n
  * Expanding: factor > 1
  */
  virtual const MeXLineMeshUnstructured&
  extractCell(double factor, const MiCellFilterI* cellFilter=NULL) = 0;
 
  /**
  * @copydoc MiCellExtractIjk::extractScalarSet(const MiScalardSetIjk& inputSet)
  */
  virtual const MeXScalardSetI& extractScalarSet(const MiScalardSetI& inputSet) = 0;

  /**
  * @copydoc MiCellExtractIjk::extractVec3Set(const MiVec3dSetIjk& inputSet)
  */
  virtual const MeXVec3dSetI& extractVec3Set(const MiVec3dSetI& inputSet) = 0;

  /**
  * @copydoc MiCellExtractIjk::getExtract()
  */
  virtual const MeXLineMeshUnstructured&    getExtract() const = 0;
};

#endif /* _MiLineCellExtractI_H */


