/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2017 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
#ifndef  _MiLineCellExtractUnstructured_H
#define  _MiLineCellExtractUnstructured_H

#include <MeshVizXLM/mesh/data/MiDataSetI.h>
#include <MeshVizXLM/extractors/MiLineCellExtractI.h>
#include <MeshVizXLM/extrmesh/data/MeXDataSetI.h>

#include <Inventor/STL/vector>

class MiTessellator;
class MiCellFilterI;
class MiLineMeshUnstructured;
class MeXPointMeshCurvilinear;

 /** 
 * @DTEXT Cell extractor for unstructured line meshes
 * 
 * @ingroup MeshVizXLM_Extract_Cell
 * 
 * @DESCRIPTION Extracts a list of cells from an input unstructured line mesh and 
 *              builds a line mesh or a point mesh containing the extracted cells.
 * 
 */

class MESHVIZXLM_EXTR_API MiLineCellExtractUnstructured : virtual public MiLineCellExtractI
{
public:
    
  virtual ~MiLineCellExtractUnstructured() {}

  /**
  * @copydoc MiCellExtractIjk::getNewInstance()
  */ 
  static MiLineCellExtractUnstructured* getNewInstance(const MiLineMeshUnstructured& mesh, bool parallel = true, MiTessellator* tessellator=NULL);

  /**
  * Creates a point mesh from the points of the line cells corresponding to the
  * given indices in the original line mesh. Cells are scaled according to the given
  * factor. @n
  * Shrinking: factor < 1 @n
  * Expanding: factor > 1
  */
  virtual const MeXPointMeshCurvilinear&
  extractPoints(const std::vector<size_t>& cellIndex, double factor, const MiCellFilterI* cellFilter=NULL) = 0;

  /**
  * Creates a point mesh from the points of the line cells of the entire input line mesh.
  * Cells are scaled according to the given
  * factor. @n
  * Shrinking: factor < 1 @n
  * Expanding: factor > 1
  */
  virtual const MeXPointMeshCurvilinear&
  extractPoints(double factor, const MiCellFilterI* cellFilter=NULL) = 0;
 
  /**
  * Returns the result of the extraction as a point mesh.
  */
  virtual const MeXPointMeshCurvilinear&    getPointExtract() const = 0;
};

#endif /* _MiLineCellExtractUnstructured_H */


