/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2024 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
#ifndef  _MiLineExtract_h
#define  _MiLineExtract_h

#include <MeshVizXLM/extractors/MiBaseExtractor.h>
#include <MeshVizXLM/mesh/data/MiDataSetI.h>
#include <MeshVizXLM/extrmesh/MeXLineMeshUnstructured.h>
#include <MeshVizXLM/extrmesh/data/MeXDataSetI.h>

class MiCellFilterI;
class MiLineMeshUnstructured;
class MiLineMeshRegular;
class MiLineMeshCurvilinear;
class MiTessellator;

/**
 * @DTEXT line mesh extractor for unstructured line mesh.
 * 
 * @ingroup MeshVizXLM_Extract_Line
 * 
 * @DESCRIPTION Builds an unstructured line mesh from an input unstructured line mesh by
 *   removing dead cells and filtered cells.
 */
class MESHVIZXLM_EXTR_API MiLineExtract : virtual public MiBaseExtractor
{
public:
  virtual ~MiLineExtract() {}

  /**
  * Factory method returning a new instance of a class implementing this interface.
  * @param mesh The input mesh
  * @param parallel When true, tries to create an extract module using a parallel algorithm to speed up the extraction.
  * @param tessellator The tessellator object used for tessellating non linear cells (quadratic,...).
  * @note The extraction algorithm does not have a parallel implementation and does not take into account the
  *       the tessellator.
  */
  static MiLineExtract* getNewInstance(const MiLineMeshUnstructured& mesh, bool parallel = true, MiTessellator* tessellator = NULL);
  static MiLineExtract* getNewInstance(const MiLineMeshRegular& mesh, bool parallel = true, MiTessellator* tessellator = NULL);
  static MiLineExtract* getNewInstance(const MiLineMeshCurvilinear& mesh, bool parallel = true, MiTessellator* tessellator = NULL);

  /**
  * Builds a new linear line mesh by removing dead cells and filtered cells from the input mesh given to the
  * factory method getNewInstance().
  * @param[in] cellFilter The optional cell filter. line cells excluded by this filter are removed in the build mesh.
  * @return The line mesh.
  */  
  virtual const MeXLineMeshUnstructured& extract(const MiCellFilterI* cellFilter=NULL) = 0;

  /**
  * Extracts a scalar set from the input line mesh. The scalars are mapped onto the
  * current extracted line.
  *
  * @param inputSet the input scalar set defined on the line mesh
  * @return the output scalar set defined on the latest extracted line mesh
  */
  virtual const MeXScalardSetI& extractScalarSet(const MiScalardSetI& inputSet) =0;

  /**
  * Extracts a vector set from the input line mesh. The vectors are mapped onto the
  * current extracted line.
  *
  * @param inputSet the input vector set defined on the input line mesh
  * @return the output vector set defined on the latest extracted line mesh
  */
  virtual const MeXVec3dSetI& extractVec3Set(const MiVec3dSetI& inputSet) = 0;

  /**
  * @copydoc MiSkinExtractIjk::getExtract()
  */
  virtual const MeXLineMeshUnstructured& getExtract() const = 0;

};

#endif

