/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2018 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
#ifndef  _MiLogicalSliceExtractHexahedronIjk_H
#define  _MiLogicalSliceExtractHexahedronIjk_H

#include <MeshVizXLM/extractors/MiBaseExtractor.h>
#include <MeshVizXLM/extractors/MiBaseLogicalSliceExtract.h>
#include <MeshVizXLM/extrmesh/MeXSurfaceMeshUnstructured.h>
#include <MeshVizXLM/mesh/data/MiDataSetIjk.h>
#include <MeshVizXLM/extrmesh/data/MeXDataSetI.h>

class MiCellFilterIjk;
class MiVolumeMeshHexahedronIjk;
class MiTessellator;

/**
* @DTEXT Logical slice extractor for an hexahedron IJK volume mesh.
* 
* @ingroup MeshVizXLM_Extract_Logicalslice
* 
* See MiLogicalSliceExtractRegular
*
*/
class MESHVIZXLM_EXTR_API MiLogicalSliceExtractHexahedronIjk : virtual public MiBaseExtractor
{
public:
  virtual ~MiLogicalSliceExtractHexahedronIjk() {} 

  /**
  * @copydoc MiInterpolatedLogicalSliceExtract::getNewInstance()
  */ 
  static MiLogicalSliceExtractHexahedronIjk* getNewInstance(const MiVolumeMeshHexahedronIjk& mesh, bool parallel = true, MiTessellator* tessellator = NULL);

  /**
  * @copydoc MiLogicalSliceExtractRegular::extractLogicalSlice()
  */ 
  virtual const MeXSurfaceMeshUnstructured& extractLogicalSlice(MiMesh::Dimension axis, size_t sliceIndex, bool upperVertex, const MiCellFilterIjk* cellFilter=NULL) = 0;


  /**
  * Computes a PER_NODE scalar set on the extracted logical slice. 
  * Note : The argument i of the method MiScalardSetI::get(i) refers
  * to the i-th node of the mesh. Thus the binding of the inputSet
  * must be PER_NODE. An exception is thrown otherwise.
  * 
  * @param inputSet the input scalar set defined on the volume mesh
  * @return the output scalar set defined on the resulting surface mesh
  */
  virtual const MeXScalardSetI& extractScalarSet(const MiScalardSetI& inputSet) = 0;

  /**
  * Computes a PER_CELL scalar set on the extracted logical slice. 
  * Note : The argument i,j,k of the method MiScalardSetIjk::get(i,j,k) refers
  * to the cell (i,j,k). Thus the binding of the inputSet
  * must be PER_CELL. An exception is thrown otherwise.
  * 
  * @param inputSet the input scalar set defined on the volume mesh
  * @return the output scalar set defined on the resulting surface mesh
  */
  virtual const MeXScalardSetI& extractScalarSet(const MiScalardSetIjk& inputSet) = 0;

  /**
  * Computes a vector set on the extracted logical slice.
  * Note : The argument i of the method MiVec3dSetI::get(i) refers
  * to the i-th node of the mesh. Thus the binding of the inputSet
  * must be PER_NODE. An exception is thrown otherwise.
  * 
  * @param inputSet the input vec3 set defined on the volume mesh
  * @return the output scalar set defined on the resulting surface mesh
  */
  virtual const MeXVec3dSetI& extractVec3Set(const MiVec3dSetI& inputSet) = 0;

  /**
  * Computes a vector set on the extracted logical slice.
  * Note : The argument i,j,k of the method MiVec3dSetIjk::get(i,j,k) refers
  * to the cell (i,j,k). Thus the binding of the inputSet
  * must be PER_CELL. An exception is thrown otherwise.
  * 
  * @param inputSet the input vec3 set defined on the volume mesh
  * @return the output scalar set defined on the resulting surface mesh
  */
  virtual const MeXVec3dSetI& extractVec3Set(const MiVec3dSetIjk& inputSet) = 0;

  /**
  * @copydoc MiCellExtractIjk::getExtract()
  */
  virtual const MeXSurfaceMeshUnstructured& getExtract() const = 0;

};

#endif /* _MiLogicalSliceExtractHexahedronIjk_H */


