/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2017 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
#ifndef  _MiOutlineExtractUnstructured_H
#define  _MiOutlineExtractUnstructured_H

#include <MeshVizXLM/extractors/MiBaseExtractor.h>
#include <MeshVizXLM/mesh/MiVolumeMeshUnstructured.h>
#include <MeshVizXLM/mesh/MiSurfaceMeshUnstructured.h>
#include <MeshVizXLM/mesh/data/MiDataSetI.h>
#include <MeshVizXLM/extrmesh/MeXLineMeshUnstructured.h>
#include <MeshVizXLM/extrmesh/data/MeXDataSetI.h>
#include <MeshVizXLM/tessellator/MiTessellator.h>

class MiCellFilterI;
class MeXPointMeshCurvilinear;

/**
 * @DTEXT Outline extractor for an unstructured mesh.
 * 
 * @ingroup MeshVizXLM_Extract_Outline
 * 
 * @DESCRIPTION Builds a MiLineMeshUnstructured interfaces containing the outline of the given mesh.
 * The outline of a mesh is made up of all the edges that belong to a single cell. 
 * Internal edges of a mesh will not be displayed except when they are
 * adjacent to dead cells.
 * 
 */
class MESHVIZXLM_EXTR_API MiOutlineExtractUnstructured : virtual public MiBaseExtractor
{
public:
  virtual ~MiOutlineExtractUnstructured() {}

  /**
  * @copydoc MiCellExtractIjk::getNewInstance()
  */
  static MiOutlineExtractUnstructured* getNewInstance(const MiVolumeMeshUnstructured& mesh, bool parallel = true, MiTessellator* tessellator=NULL);
  static MiOutlineExtractUnstructured* getNewInstance(const MiSurfaceMeshUnstructured& mesh, bool parallel = true, MiTessellator* tessellator=NULL);

  /**
  * @copydoc MiOutlineExtractIjk::extractOutline()
  */
  virtual const MeXLineMeshUnstructured& extractOutline(const MiCellFilterI* cellFilter=NULL) = 0;
  virtual const MeXPointMeshCurvilinear& extractPoints(const MiCellFilterI* cellFilter=NULL) = 0;
  
  /**
  * @copydoc MiOutlineExtractIjk::extractScalarSet()
  */
  virtual const MeXScalardSetI& extractScalarSet(const MiScalardSetI& inputSet) = 0;

  /**
  * @copydoc MiOutlineExtractIjk::extractVec3Set()
  */
  virtual const MeXVec3dSetI& extractVec3Set(const MiVec3dSetI& inputSet) = 0;
 
  /**
  * @copydoc MiOutlineExtractIjk::getExtract()
  */
  virtual const MeXLineMeshUnstructured& getExtract() const = 0;
  virtual const MeXPointMeshCurvilinear& getPointExtract() const = 0;

};

#endif /* _MiOutlineExtractUnstructured_H */


