/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2019 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : Martial Bonaventure (December 2009)
**=======================================================================*/
#ifndef  _MiPerCellToPerNodeExtractHexahedronIjk_h
#define  _MiPerCellToPerNodeExtractHexahedronIjk_h

#include <MeshVizXLM/extractors/MiBaseExtractor.h>
#include <MeshVizXLM/mesh/data/MiDataSetIjk.h>
#include <MeshVizXLM/extrmesh/data/MeXDataSetI.h>

class MiVolumeMeshHexahedronIjk;

/**
 * @DTEXT Convert data sets bound per cell into data sets bound per node on a given structured hexahedron mesh.
 * 
 * @ingroup MeshVizXLM_Extract_Utilities
 * 
 * @DESCRIPTION 
 * This conversion tool is another type of extractor which takes a data set bound per cell on a
 * MiVolumeMeshHexahedronIjk as input and produces a new data set bound per node on the same mesh. 
 *
 * The value computed at a given node is the average of values from cells sharing this node,
 * except dead cells. 
 * 
 * The following example shows how to convert data sets bound per cell:
 * \if_cpp
 * \code
 * MiPerCellToPerNodeExtractHexahedronIjk* extract =
 *   MiPerCellToPerNodeExtractHexahedronIjk::getNewInstance(mesh);
 * const MeXScalardSetI& perNodeScalarSet = extract->extractScalarSet(perCellScalarSet);
 * const MeXVec3dSetI&   perNodeVectorSet = extract->extractVec3Set(perCellVectorSet);
 * \endcode
 * \endif
 * \if_dotnet
 * \endif
 * \if_java
 * \endif
 *
 */
class MESHVIZXLM_EXTR_API MiPerCellToPerNodeExtractHexahedronIjk : virtual public MiBaseExtractor
{
public:
  virtual ~MiPerCellToPerNodeExtractHexahedronIjk() {}

  /**
  * Factory method returning a new instance of a class implementing this abstract class.
  * @param mesh The input mesh 
  * @param parallel When true, tries to create an extract module using a parallel algorithm to speed up the extraction. 
  * @note Only some of the extraction algorithms have a parallel implementation.
  */ 
  static MiPerCellToPerNodeExtractHexahedronIjk* getNewInstance(const MiVolumeMeshHexahedronIjk& mesh, bool parallel = true); 

  /**
  * @copydoc MiPerCellToPerNodeExtractUnstructured::extractScalarSet()
  */
  virtual const MeXScalardSetI& extractScalarSet(const MiScalardSetIjk& inputSet) =0;

  /**
  * @copydoc MiPerCellToPerNodeExtractUnstructured::extractVec3Set()
  */ 
  virtual const MeXVec3dSetI& extractVec3Set(const MiVec3dSetIjk& inputSet) = 0;

};

#endif

