/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2019 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : Martial Bonaventure (December 2009)
**=======================================================================*/
#ifndef  _MiPerCellToPerNodeExtractUnstructured_h
#define  _MiPerCellToPerNodeExtractUnstructured_h

#include <MeshVizXLM/extractors/MiBaseExtractor.h>
#include <MeshVizXLM/mesh/data/MiDataSetI.h>
#include <MeshVizXLM/extrmesh/data/MeXDataSetI.h>

class MiVolumeMeshUnstructured;
class MiSurfaceMeshUnstructured;

/**
 * @DTEXT Convert data sets bound per cell into data sets bound per node on a given unstructured mesh.
 * 
 * @ingroup MeshVizXLM_Extract_Utilities
 * 
 * @DESCRIPTION 
 * This conversion tool is another type of extractor which takes a data set bound per cell on an
 * unstructured mesh as input and produces a new data set bound per node on the same mesh. 
 *
 * The value computed at a given node is the average of values from cells sharing this node,
 * except dead cells. 
 * 
 * The following example shows how to convert data sets bound per cell:
 * \if_cpp
 * \code
 *   MiPerCellToPerNodeExtractUnstructured* extract =
 *     MiPerCellToPerNodeExtractUnstructured::getNewInstance(mesh);
 *   const MeXScalardSetI& perNodeScalarSet = extract->extractScalarSet(perCellScalarSet);
 *   const MeXVec3dSetI& perNodeVectorSet = extract->extractVec3Set(perCellVectorSet);
 * \endcode
 * \endif
 * \if_dotnet
 * \endif
 * \if_java
 * \endif
 *
 */
class MESHVIZXLM_EXTR_API MiPerCellToPerNodeExtractUnstructured : virtual public MiBaseExtractor
{
public:
  virtual ~MiPerCellToPerNodeExtractUnstructured() {}

  //@{
  /**
  * Factory method returning a new instance of a class implementing this abstract class.
  * @param mesh The input mesh 
  * @param parallel When true, tries to create an extract module using a parallel algorithm to speed up the extraction. 
  * @note Only some of the extraction algorithms have a parallel implementation.
  */ 
  static MiPerCellToPerNodeExtractUnstructured* getNewInstance(const MiVolumeMeshUnstructured& mesh, bool parallel = true); 
  static MiPerCellToPerNodeExtractUnstructured* getNewInstance(const MiSurfaceMeshUnstructured& mesh, bool parallel = true); 
  //@}

  /**
  * Converts a PER_CELL scalar set defined on the input mesh into a PER_NODE scalar set.
  *
  * @param inputSet The input PER_CELL scalar set defined on the input mesh.
  * @return The output PER_NODE scalar set defined on the input mesh.
  */
  virtual const MeXScalardSetI& extractScalarSet(const MiScalardSetI& inputSet) =0;

  /**
  * Converts a PER_CELL vector set defined on the input mesh into a PER_NODE vecto set.
  *
  * @param inputSet The input PER_CELL vector set defined on the input mesh.
  * @return The output PER_NODE vector set defined on the input mesh.
  */ 
  virtual const MeXVec3dSetI& extractVec3Set(const MiVec3dSetI& inputSet) = 0;

};

#endif

