/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2019 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
#ifndef  _MiPolyhedralToMixVolumeExtract_h
#define  _MiPolyhedralToMixVolumeExtract_h

#include <MeshVizXLM/extractors/MiBaseExtractor.h>
#include <MeshVizXLM/mesh/data/MiDataSetI.h>
#include <MeshVizXLM/extrmesh/MeXVolumeMeshUnstructured.h>
#include <MeshVizXLM/extrmesh/data/MeXDataSetI.h>

#include <Inventor/STL/vector>

class MiCellFilterI;
class MiVolumeMeshUnstructured;

/**
 * @DTEXT Convert polyhedral 3D mesh to mixed volume mesh.
 * 
 * @ingroup MeshVizXLM_Extract_Utilities
 * 
 * @DESCRIPTION 
 * This conversion tool is another type of extractor which takes a polyhedral volume mesh
 * as input and produces a mixed volume mesh made up of a combination of tetrahedrons 
 * and pyramids compatible with the marching cube algorithm. 
 * 
 * The following example shows how to convert a polyhedral volume mesh to a mixed volume mesh:
 * \if_cpp
 * \code
 *   MiPolyhedralToMixVolume* extract =
 *     MiPolyhedralToMixVolume::getNewInstance(mesh);
 *   const MeXVolumeMeshUnstructured tessMesh = extract->convert();
 * \endcode
 * \endif
 * \if_dotnet
 * \endif
 * \if_java
 * \endif
 *
 */
class MESHVIZXLM_EXTR_API MiPolyhedralToMixVolumeExtract : virtual public MiBaseExtractor
{
public:
  virtual ~MiPolyhedralToMixVolumeExtract() {}

  /**
  * Factory method returning a new instance of a class implementing this abstract class.
  * @param mesh The input mesh 
  * @param parallel When true, tries to create an extract module using a parallel algorithm to speed up the extraction. 
  * @note Only some of the extraction algorithms have a parallel implementation.
  */ 
  static MiPolyhedralToMixVolumeExtract* getNewInstance(const MiVolumeMeshUnstructured& mesh, bool parallel = true); 

  /**
  * Builds the topology and geometry of the mixed volume mesh.
  */  
  virtual const MeXVolumeMeshUnstructured& convert(const MiCellFilterI* cellFilter=NULL) = 0;

  /**
  * @copydoc MiCellExtractIjk::extractScalarSet()
  */  
  virtual const MeXScalardSetI& extractScalarSet(const MiScalardSetI& inputSet) =0;

 /**
  * @copydoc MiCellExtractIjk::extractVec3Set()
  */  
  virtual const MeXVec3dSetI& extractVec3Set(const MiVec3dSetI& inputSet) = 0;

 /**
  * @copydoc MiCellExtractIjk::getExtract()
  */
 virtual const MeXVolumeMeshUnstructured& getExtract() const = 0;

};

#endif

