/*=======================================================================
** VSG_COPYRIGHT_TAG
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/

#pragma once

#include <MeshVizXLM/extractors/MiBaseExtractor.h>
#include <MeshVizXLM/extrmesh/MeXSurfaceMeshCurvilinear.h>
#include <MeshVizXLM/mesh/cell/MiCellFilterIj.h>
#include <MeshVizXLM/extrmesh/data/MeXDataSetIj.h>
#include <MeshVizXLM/mesh/data/MiDataSetIj.h>

/**
 * @PREVIEWTAG
 * 
 * @DESCRIPTION
 * Build a curvilinear mesh that fits the input one but with a
 * given number of cells along I and J.
 * 
 * @ingroup MeshVizXLM_Extract_Surface
 * @PREVIEWFEATURES
 */
class MESHVIZXLM_EXTR_API MiResampledSurfaceExtractCurvilinear : virtual public MiBaseExtractor
{
public:
  virtual ~MiResampledSurfaceExtractCurvilinear() {}

  /**
  * Factory method returning a new instance of a class implementing this abstract class.
  * @param mesh The input mesh 
  * @note Only some of the extraction algorithms have a parallel implementation.
  */ 
  static MiResampledSurfaceExtractCurvilinear* getNewInstance( const MiSurfaceMeshCurvilinear& mesh );

  /**
   * Build a new curvilinear mesh fitting the given input mesh, but with the given
   * number of cell along I and J.
   * 
   * This extractor does not currently supports dead cells in the input mesh.
   * 
   * @param numCellsI The number of cells of the output mesh along I.
   * @param numCellsJ The number of cells of the output mesh along J.
   * @param cellFilter unused by the extractor for now.
   */
  virtual const MeXSurfaceMeshCurvilinear& extract( size_t numCellsI, size_t numCellsJ, const MiCellFilterIj* cellFilter = NULL ) = 0;

  /**
   * @copydoc MiSurfaceExtractIj::extractVec3Set()
   */
  virtual const MeXVec3dSetIj& extractVec3Set( const MiVec3dSetIj& inputSet ) = 0;

  /**
   * @copydoc MiSurfaceExtractIj::extractScalarSet()
   */
  virtual const MeXScalardSetIj& extractScalarSet( const MiScalardSetIj& inputSet ) = 0;
};
