/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2017 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
#ifndef  _MiStreamlineExtractBase_H
#define  _MiStreamlineExtractBase_H

#include <MeshVizXLM/MxMeshVizXLM.h>
#include <MeshVizXLM/extractors/MiBaseExtractor.h>

/**
 * @DTEXT Base class for all streamline extractors.
 * 
 * @ingroup MeshVizXLM_Extract_Streamline
 * 
 * @DESCRIPTION
 *
 *    The base streamline extract interface defines the commun optional parameters
 *    and the direction enum used to integrate streamlines
 * 
 */

class MESHVIZXLM_EXTR_API MiStreamlineExtractBase : virtual public MiBaseExtractor
{
public:

  virtual ~MiStreamlineExtractBase() {}

  /**
  * Sets the maximum life time of the streamlines.
  * This method is not pure virtual so that no definition is needed if not used
  * @param maxLifeTime maximum life time of the streamlines.
  * Default: 0, i.e infinite life time.
  */
  virtual void setMaxLifeTime(double SO_UNUSED_PARAM(maxLifeTime)) {}
  /**
  * Sets the maximum length of the streamlines.
  * This method is not pure virtual so that no definition needed if not used
  * @param maxLength maximum length of the streamlines.
  * Default: 0, i.e infinite length.
  */
  virtual void setMaxLength(double SO_UNUSED_PARAM(maxLength)) {}
  /**
  * Sets the minimum speed of the streamlines.
  * This method is not pure virtual so that no definition needed if not used
  * @param minSpeed minimum speed of the streamlines.
  * Default: 0, i.e no speed constraint.
  */
  virtual void setMinSpeed(double SO_UNUSED_PARAM(minSpeed)) {}
  /**
  * Sets the step length factor for the streamlines integration.
  * This method is not pure virtual so that no definition needed if not used
  * @param factor length factor for the streamlines integration.
  * Defaul: 0.3.
  */
  virtual void setIntegrationStepLengthFactor(double SO_UNUSED_PARAM(factor)) {}
  /**
  * Sets the maximum step number during the streamlines integration.
  * This method is not pure virtual so that no definition needed if not used
  * @param maxStepNumber maximum step number.
  * Default: 0, i.e infinite step number.
  */
  virtual void setIntegrationMaxStepNumber(int SO_UNUSED_PARAM(maxStepNumber)) {} 

  /**
  * Integration direction
  */
  enum IntegrationDirection {
    FORWARD,  /**< Integration is done in the direction of the vectors.*/
    BACKWARD  /**< Integration is done in the opposite direction of the vectors. */
} ;

  /**
  * Sets the direction for the streamlines integration.
  * This method is not pure virtual so that no definition needed if not used
  * @param direction direction for the streamlines integration.
  * Default: FORWARD.
  */
  virtual void setIntegrationDirection(IntegrationDirection SO_UNUSED_PARAM(direction)) {}

};

#endif /* _MiStreamlineExtractBase_H */


