/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2019 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
#ifndef  _MiStreamlineExtractHexahedronIjk_H
#define  _MiStreamlineExtractHexahedronIjk_H

#include <MeshVizXLM/extractors/MiStreamlineExtractIjk.h>
#include <MeshVizXLM/extrmesh/MeXLineMeshCurvilinear.h>
#include <MeshVizXLM/extrmesh/data/MeXDataSetI.h>
#include <MeshVizXLM/mesh/data/MiDataSetIjk.h>

class MiCellFilterIjk;
class MiVolumeMeshHexahedronIjk;

#include <Inventor/STL/vector>

/**
 * @DTEXT  Streamline extractor for hexahedron IJK volume meshes.
 * 
 * @ingroup MeshVizXLM_Extract_Streamline
 * 
 * @DESCRIPTION
 *    Builds a list of MiLineMeshCurvilinear interfaces containing streamlines starting 
 *    from a list of source points and probes the input mesh to compute the values at the
 *    streamline nodes (See MiPointProbeUnstructured for settings). @BR
 *    A streamline is a line that is everywhere tangent to a vector field. 
 *    Streamlines are meaningless for unsteady flow, because time is not
 *    taken into account during the computation of the line. 
 *    Streamlines are integrated from a given set of vectors using a Runge/Kutta
 *    method of order 2 .
 * 
 */
class MESHVIZXLM_EXTR_API MiStreamlineExtractHexahedronIjk : virtual public MiStreamlineExtractIjk
{
public:
  
  /**
  * Factory method returning a new instance of a class implementing this abstract class.
  * @param mesh The input mesh 
  * @param parallel When true, tries to create an extract module using a parallel algorithm to speed up the extraction. 
  * @note Only some of the extraction algorithms have a parallel implementation.
  */ 
  static MiStreamlineExtractHexahedronIjk* getNewInstance(const MiVolumeMeshHexahedronIjk& mesh, bool parallel = true);

  //@{
  /**
  * Builds the topology and geometry of the streamlines starting at the given points in 
  * the given dataset. The resulting streamlines can be retrieved by calling getExtract().
  *
  * Note: the dataset associated to the mesh 
  * are not extracted by this method. Thus, the resulting streamlines generated
  * contain only their geometry and topology extracted from the input dataset.
  * In order to extract some dataset the methods extractScalarSet(), extractVec3Set()
  * must be explicitly called after extractStreamline().
  * Returns the result of the streamline extraction as a list of line meshes.
  *
  * @param inputdataset: defines the vector field for the streamlines integration
  * @param startPoints: defines the list of start points for the streamlines integration
  * @param cellFilter:
  * @return the extracted streamlines as curvilinear line meshes
  */
  virtual const std::vector<const MeXLineMeshCurvilinear*>&
  extractStreamline(const MiVec3dSetI& inputdataset, const std::vector<MbVec3d>& startPoints, const MiCellFilterIjk* cellFilter=NULL) = 0;
  virtual const std::vector<const MeXLineMeshCurvilinear*>&
  extractStreamline(const MiVec3dSetIjk& inputdataset, const std::vector<MbVec3d>& startPoints, const MiCellFilterIjk* cellFilter=NULL) = 0;
  //@}

 /**
 * Computes a PER_NODE scalar set on the extracted streamlines. 
 * Note : The argument i of the method MiScalardSetI::get(i) refers
 * to the i-th node of the mesh. Thus the binding of the inputSet
 * must be PER_NODE. An exception is thrown otherwise.
 * 
 * @param inputSet the input scalar set defined on the volume mesh
 * @return the output scalar sets defined on the resulting streamline meshes
 */
 virtual const std::vector< const MeXScalardSetI* >& extractScalarSet(const MiScalardSetI& inputSet) = 0;

 /**
 * Computes a PER_CELL scalar set on the extracted isosurface. 
 * Note : The argument i,j,k of the method MiScalardSetIjk::get(i,j,k) refers
 * to the cell (i,j,k). Thus the binding of the inputSet
 * must be PER_CELL. An exception is thrown otherwise.
 * 
 * @param inputSet the input scalar set defined on the volume mesh
 * @return the output scalar sets defined on the resulting streamline meshes
 */
 virtual const std::vector< const MeXScalardSetI* >& extractScalarSet(const MiScalardSetIjk& inputSet) = 0;

 /**
 * Computes a vector set on the extracted isosurface.
 * Note : The argument i of the method MiVec3dSetI::get(i) refers
 * to the i-th node of the mesh. Thus the binding of the inputSet
 * must be PER_NODE. An exception is thrown otherwise.
 * 
 * @param inputSet the input vec3 set defined on the volume mesh
 * @return the output scalar set defined on the resulting streamline meshes
 */
 virtual const std::vector< const MeXVec3dSetI* >& extractVec3Set(const MiVec3dSetI& inputSet) = 0;

 /**
 * Computes a vector set on the extracted isosurface.
 * Note : The argument i,j,k of the method MiVec3dSetIjk::get(i,j,k) refers
 * to the cell (i,j,k). Thus the binding of the inputSet
 * must be PER_CELL. An exception is thrown otherwise.
 * 
 * @param inputSet the input vec3 set defined on the volume mesh
 * @return the output scalar set defined on the resulting streamline meshes
 */
 virtual const std::vector< const MeXVec3dSetI* >& extractVec3Set(const MiVec3dSetIjk& inputSet) = 0;

};


#endif 


