/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2019 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
#ifndef  _MISTREAMLINEEXTRACTUNSTRUCTURED_H
#define  _MISTREAMLINEEXTRACTUNSTRUCTURED_H

#include <MeshVizXLM/extractors/MiStreamlineExtractBase.h>
#include <MeshVizXLM/extrmesh/MeXLineMeshCurvilinear.h>
#include <MeshVizXLM/extrmesh/data/MeXDataSetI.h>
#include <MeshVizXLM/mesh/data/MiDataSetI.h>

class MiCellFilterI;
class MiVolumeMeshUnstructured;
class MiSurfaceMeshUnstructured;

#include <Inventor/STL/vector>

/**
 * @DTEXT  Streamline extractor for unstructured volume meshes.
 * 
 * @ingroup MeshVizXLM_Extract_Streamline
 * 
 * @DESCRIPTION
 *    Builds a list of MiLineMeshCurvilinear interfaces containing streamlines starting 
 *    from a list of source points and probes the input mesh to compute the values at the
 *    streamline nodes (See MiPointProbeUnstructured for settings). @BR
 *    A streamline is a line that is everywhere tangent to a vector field. 
 *    Streamlines are meaningless for unsteady flow, because time is not
 *    taken into account during the computation of the line. 
 *    Streamlines are integrated from a given set of vectors using a Runge/Kutta
 *    method of order 2 .
 * 
 */
class MESHVIZXLM_EXTR_API MiStreamlineExtractUnstructured : virtual public MiStreamlineExtractBase
{
public:

  //@{
  /**
  * Factory method returning a new instance of a class implementing this abstract class.
  * @param mesh The input mesh 
  * @param parallel When true, tries to create an extract module using a parallel algorithm to speed up the extraction. 
  * @note Only some of the extraction algorithms have a parallel implementation.
  */ 
  static MiStreamlineExtractUnstructured* getNewInstance(const MiVolumeMeshUnstructured& mesh, bool parallel = true);
  static MiStreamlineExtractUnstructured* getNewInstance(const MiSurfaceMeshUnstructured& mesh, bool parallel = true);
  //@}

  /**
  * Builds the topology and geometry of the streamlines starting at the given points in 
  * the given dataset. The resulting streamlines can be retrieved by calling getExtract().
  *
  * @param inputDataSet Defines the vector field for the streamlines integration
  * @param startPoints Defines the list of start points for the streamlines integration
  * @param cellFilter The cell filter
  * @return the extracted streamlines as curvilinear line meshes
  */
  virtual const std::vector<const MeXLineMeshCurvilinear*>&
  extractStreamline(const MiVec3dSetI& inputDataSet, const std::vector<MbVec3d>& startPoints, const MiCellFilterI* cellFilter=NULL) = 0;

  /**
  * @copydoc MiStreamlineExtractIjk::extractScalarSet()
  */ 
  virtual const std::vector< const MeXScalardSetI* >& extractScalarSet(const MiScalardSetI& inputSet) = 0;

  /**
  * @copydoc MiStreamlineExtractIjk::extractVec3Set()
  */ 
  virtual const std::vector< const MeXVec3dSetI* >& extractVec3Set(const MiVec3dSetI& inputSet) = 0;

  /**
  * @copydoc MiStreamlineExtractIjk::getExtract()
  */ 
  virtual const std::vector<const MeXLineMeshCurvilinear*>& getExtract() const = 0;

};

#endif /* _MISTREAMLINEEXTRACTUNSTRUCTURED_H */


