/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2017 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
#ifndef  _MISTREAMLINEEXTRACTUNSTRUCTUREDIJK_H
#define  _MISTREAMLINEEXTRACTUNSTRUCTUREDIJK_H

#include <MeshVizXLM/extractors/MiStreamlineExtractHexahedronIjk.h>

/**
 * @DTEXT  Streamline extractor for hexahedron IJK volume meshes.
 * 
 * @ingroup MeshVizXLM_Extract_Streamline
 * 
 * @DESCRIPTION
 *    Builds a list of MiLineMeshCurvilinear interfaces containing streamlines starting 
 *    from a list of source points and probes the input mesh to compute the values at the
 *    streamline nodes (See MiPointProbeUnstructured for settings). @BR
 *    A streamline is a line that is everywhere tangent to a vector field. 
 *    Streamlines are meaningless for unsteady flow, because time is not
 *    taken into account during the computation of the line. 
 *    Streamlines are integrated from a given set of vectors using a Runge/Kutta
 *    method of order 2 .
 * 
 */

typedef SoDEPRECATED_TYPEDEF(10000,"Use MiStreamlineExtractHexahedronIjk interface instead.") MiStreamlineExtractHexahedronIjk MiStreamlineExtractUnstructuredIjk;


#endif 


