/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2024 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
#ifndef  _MiSurfaceExtractIj_h
#define  _MiSurfaceExtractIj_h

#include <MeshVizXLM/extractors/MiBaseExtractor.h>
#include <MeshVizXLM/mesh/data/MiDataSetIj.h>
#include <MeshVizXLM/extrmesh/MeXSurfaceMeshUnstructured.h>
#include <MeshVizXLM/extrmesh/data/MeXDataSetI.h>

class MiCellFilterIj;
class MiSurfaceMeshRegular;
class MiSurfaceMeshRectilinear;
class MiSurfaceMeshCurvilinear;
class MiTessellator;

/**
 * @DTEXT Surface mesh extractor for structured surface mesh.
 * 
 * @ingroup MeshVizXLM_Extract_Surface
 * 
 * @DESCRIPTION Builds an unstructured surface mesh from a structured surface mesh (regular, rectilinear or curvilinear) by
 *   removing dead cells and filtered cells.
 */
class MESHVIZXLM_EXTR_API MiSurfaceExtractIj : virtual public MiBaseExtractor
{
public:
  virtual ~MiSurfaceExtractIj() {}

  /**
  * @copydoc MiInterpolatedLogicalSliceExtract::getNewInstance()
  */ 
  static MiSurfaceExtractIj* getNewInstance(const MiSurfaceMeshRegular& mesh, bool parallel = true, MiTessellator* tessellator = NULL);
  static MiSurfaceExtractIj* getNewInstance(const MiSurfaceMeshRectilinear& mesh, bool parallel = true, MiTessellator* tessellator = NULL);
  static MiSurfaceExtractIj* getNewInstance(const MiSurfaceMeshCurvilinear& mesh, bool parallel = true, MiTessellator* tessellator = NULL);

  /**
  * Builds a new unstructured surface mesh by removing dead cells and filtered cells from the input mesh given to the
  * factory method getNewInstance().
  * @param[in] cellFilter The optional cell filter. surface cells excluded by this filter are removed in the build mesh.
  * @return The surface mesh.
  */
  virtual const MeXSurfaceMeshUnstructured& extract(const MiCellFilterIj* cellFilter=NULL) = 0;

  /**
  * @copydoc MiSurfaceExtractUnstructured::extractScalarSet()
  */
  virtual const MeXScalardSetI& extractScalarSet(const MiScalardSetIj& inputSet) =0;

  /**
  * @copydoc MiSurfaceExtractUnstructured::extractVec3Set()
  */
  virtual const MeXVec3dSetI& extractVec3Set(const MiVec3dSetIj& inputSet) = 0;

  /**
  * @copydoc MiSurfaceExtractUnstructured::getExtract()
  */
 virtual const MeXSurfaceMeshUnstructured& getExtract() const = 0;

};

#endif

