/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2017 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
#ifndef  _MiTessellatedVolumeExtract_h
#define  _MiTessellatedVolumeExtract_h

#include <MeshVizXLM/extractors/MiBaseExtractor.h>
#include <MeshVizXLM/mesh/data/MiDataSetI.h>
#include <MeshVizXLM/extrmesh/MeXVolumeMeshUnstructured.h>
#include <MeshVizXLM/extrmesh/data/MeXDataSetI.h>

class MiCellFilterI;
class MiVolumeMeshUnstructured;
class MiTessellator;

 /*
 * @DTEXT Tessellated volume extractor for unstructured 3D mesh.
 * 
 * @ingroup MeshVizXLM_Extract_Tessellate
 * 
 * @DESCRIPTION Builds a tesselated linear volume mesh from a 3D mesh.
 *  The tessellation is done by using the given MiTessellator (see tessellate()).
 */

SoINTERNAL class MESHVIZXLM_EXTR_API MiTessellatedVolumeExtract : virtual public MiBaseExtractor
{
public:
  virtual ~MiTessellatedVolumeExtract() {}

  /**
  * @copydoc MiInterpolatedLogicalSliceExtract::getNewInstance()
  */ 
  static MiTessellatedVolumeExtract* getNewInstance(const MiVolumeMeshUnstructured& mesh, bool parallel = true); 

  /**
  * Builds a new linear volume mesh by tessellating each cell of the input mesh given to the
  * factory method getNewInstance(). The tessellation is defined by the given tessellator.
  * @param[in] tesselator The instance used to tessellate.
  * @param[in] cellFilter The optional cell filter. volume cells excluded by this filter are neither tessellated nor
  *            included "as is" in the build mesh.
  * @return The tessellated mesh.
  */  
  virtual const MeXVolumeMeshUnstructured& tessellate(MiTessellator& tesselator, const MiCellFilterI* cellFilter=NULL) = 0;

  /**
  * @copydoc MiTessellatedLineExtract::extractScalarSet()
  */
  virtual const MeXScalardSetI& extractScalarSet(const MiScalardSetI& inputSet) =0;

  /**
  * @copydoc MiTessellatedLineExtract::extractVec3Set()
  */
  virtual const MeXVec3dSetI& extractVec3Set(const MiVec3dSetI& inputSet) = 0;

  /**
  * @copydoc MiTessellatedLineExtract::getExtract()
  */
  virtual const MeXVolumeMeshUnstructured& getExtract() const = 0;

};

#endif

