/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2017 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
#ifndef  _MxPolygonCellExtract_h
#define  _MxPolygonCellExtract_h

#include <MeshVizXLM/mesh/geometry/MiGeometryI.h>

#include <Inventor/STL/vector>
#include <Inventor/STL/utility>

class MiSurfaceCell;

/**
* @DTEXT Utility class for polygon cells.
* 
* @ingroup MeshVizXLM_Extract_Cell
* 
* @DESCRIPTION
*   Utility class that provides a static implementation of the MiVolumeCell interface methods
*   for a polygon cell. This class is provided to make it easier to create 
*   a class that implements the MiVolumeCell interface for a polygon cell. 
*
*      - Value of the weights (aka shape functions) in a polygon cell
*        (see getWeight())
*      - Localization test (see isPointInsideCell())
*
*/
class MESHVIZXLM_EXTR_API MxPolygonCellExtract 
{
public:

  /**
  * Gets the barycentric weights in the given polygon cell of the given point. This static method 
  * helps to implement the method MiCell::getWeight(meshGeometry,point,weights) 
  * for a polygon cell. 
  * @note Each node coordinate of the given cell is retrieved in the following way:
  * @verbatim
  meshGeometry.getCoord(polygonCell->getNodeIndex(i)) 
  @endverbatim
  * for each i with 0 <= i < polygonCell->getNumNodes()
  * @param[in] meshGeometry The geometry of the mesh.
  * @param[in] polygonCell The input cell.
  * @param[in] point The input point given in the same space coordinate as meshGeometry.
  * @param[out] weights This method computes the N values weights[0,N-1], where N=polygonCell->getNumNodes().
  *    It assumes the weights vector array has been already allocated.
  *    Its size must be set to N (at least) before calling this method, using for instance
  *    the weights.resize(N)
  */
  static void getWeight(const MiGeometryI& meshGeometry, const MiSurfaceCell* polygonCell, const MbVec3d &point, std::vector<double>& weights);

  /**
  * Gets the longest edge of a polygon cell
  */
  static double getLongestEdgeLength(const MiGeometryI& meshGeometry, const MiSurfaceCell* polygonCell);

  /**
  * Gets the shortest edge of a polygon cell
  */
  static double getShortestEdgeLength(const MiGeometryI& meshGeometry, const MiSurfaceCell* polygonCell);

  /**
  * Checks if a point is inside the given polygon cell.
  * @note Each node coordinate of the given cell is retrieved in the following way:
  * @verbatim
  meshGeometry.getCoord(polygonCell->getNodeIndex(i)) 
  @endverbatim
  * for each i with 0 <= i < polygonCell->getNumNodes()
  * @param[in] meshGeometry The geometry of the mesh.
  * @param[in] polygonCell The input cell.
  * @param[in] point The input point given in the same space coordinate as meshGeometry.
  * @param[out] weights This method computes the N values weights[0,N-1], where N=polygonCell->getNumNodes().
  *    It assumes the weights vector array has been already allocated.
  *    Its size must be set to N (at least) before calling this method, using for instance
  *    the weights.resize(N)
  */
  static bool isPointInsideCell(const MiGeometryI& meshGeometry, const MiSurfaceCell* polygonCell, const MbVec3d &point, std::vector<double>& weights);

  /**
  * Computes the area of all planar or almost-planar irregular polygon (convex and concave).
  * @param[in] meshGeometry The geometry of the mesh.
  * @param[in] polygonCell The input cell.
  */
  static double getArea(const MiGeometryI& meshGeometry, const MiSurfaceCell* polygonCell);

  /**
  * Computes the average normal to the given planar or almost-planar polygon cell.
  * This is done by using Newell's method.
  * @param[in] meshGeometry The geometry of the mesh.
  * @param[in] polygonCell The input cell.
  */
  static MbVec3d getNormal(const MiGeometryI& meshGeometry, const MiSurfaceCell *polygonCell);

protected:

  static bool initClass();
  static void exitClass();
  static double cot(const MbVec3d& v1, const MbVec3d& v2, const MbVec3d& normal);

  static bool   s_isInit;

};

#endif 

