/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2017 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
#ifndef _MeXSurfaceMeshCurvilinear_H
#define _MeXSurfaceMeshCurvilinear_H

#ifdef _WIN32
#  pragma warning( push )
#  pragma warning(disable:4250)
#endif

#include <MeshVizXLM/extrmesh/geometry/MeXGeometryIj.h>
#include <MeshVizXLM/extrmesh/MeXMeshIj.h>
#include <MeshVizXLM/mesh/MiSurfaceMeshCurvilinear.h>

/**
* @DTEXT Extracted curvilinear surface mesh abstract interface.
* 
* @ingroup MeshVizXLM_ExtractedMesh
* 
* @DESCRIPTION
*    A Curvilinear Surface mesh is similar to a MiMeshIJ except that nodes are 
*    organized in a (NUMI+1,NUMJ+1) array where they can be accessed by (i,j) indices.
*    So each node located inside the mesh (not on a border) is shared by four cells. 
*    However, the nodes are not evenly spaced as they can be in the MiSurfaceMeshRectilinear or MiSurfaceMeshRegular.
*
*    @note Notice that, the virtual methods are the same as in the parent class. 
*    The RTTI system is used by some extraction algorithms to identify the mesh type in order to implement some specific 
*    optimization based on the properties described above. 
* 
*/
class MeXSurfaceMeshCurvilinear : public MiSurfaceMeshCurvilinear, virtual public MeXMeshIj
{
public:
  /**
  * Returns the geometry of this mesh. 
  */
  virtual const MeXGeometryIj& getGeometry() const = 0;

  /**
  * @copydoc MeXSurfaceMeshUnstructured::getNewClone() const
  */
  virtual const MeXSurfaceMeshCurvilinear* getNewClone() const = 0;
};

#ifdef _WIN32
#  pragma warning( pop )
#endif

#endif


