/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2017 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
#ifndef _MeXSurfaceMeshRegular_H
#define _MeXSurfaceMeshRegular_H

#ifdef _WIN32
#  pragma warning( push )
#  pragma warning(disable:4250)
#endif

#include <MeshVizXLM/extrmesh/MeXMeshIj.h>
#include <MeshVizXLM/mesh/MiSurfaceMeshRegular.h>
#include <MeshVizXLM/extrmesh/geometry/MeXGeometryRegular.h>

#include <Inventor/STL/ostream>
/**
* @DTEXT Extracted regular surface mesh abstract interface.
* 
* @ingroup MeshVizXLM_ExtractedMesh
* 
* @DESCRIPTION
*   This interface defines an extracted regular surface mesh. 
*   It is a rectangular surface subdivided into rectangular cells.
*   All cells have the same size.
*   The geometry of this rectangle is given by getMin() and getMax() 
*   inherited from MiMeshRegular::getGeometry(). 
*   The number of cells on each axis is given by getNumCellsI(), 
*   and getNumCellsJ() inherited from MiMeshIj::getTopology().
*
*/
class MeXSurfaceMeshRegular : public MiSurfaceMeshRegular, virtual public MeXMeshIj
{
public:
  /**
  * Returns the geometry of this mesh. 
  */
  virtual const MeXGeometryRegular& getGeometry() const = 0;

  /**
  * @copydoc MeXSurfaceMeshUnstructured::getNewClone() const
  */
  virtual const MeXSurfaceMeshRegular* getNewClone() const = 0;
};

#ifdef _WIN32
#  pragma warning( pop )
#endif

#endif


