/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2017 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
#ifndef _MeXSurfaceCell_H
#define _MeXSurfaceCell_H

#ifdef _WIN32
#  pragma warning( push )
#  pragma warning(disable:4250)
#endif

#include <MeshVizXLM/mesh/cell/MiSurfaceCell.h>
#include <MeshVizXLM/extrmesh/cell/MeXCell.h>

/**
* @DTEXT  Defines an abstract cell of an extracted surface mesh.
* 
* @ingroup MeshVizXLM_ExtractedMesh_Cell
* 
* @DESCRIPTION
*    A surface cell is a polygon element that connects adjacent nodes of a surface mesh.
* 
*/

class MeXSurfaceCell : public MiSurfaceCell
{
public:

  /**
  * Gets the number of edges. @BR For non linear cell, the number of edges is independent
  * of the order of the cell. For instance, getNumEdges will always return 3 for
  * a linear triangle cell, a quadratic triangle cell, a cubic triangle cell etc...
  */
  virtual size_t getNumEdges() const = 0;

  /**
  * Gets the area of the cell.
  * An application does not need to override this method.
  * 
  * @param[in] meshGeometry The geometry of the mesh. Used to retrieve the node coordinates
  * of this cell.
  */
  virtual double getArea(const MiGeometryI* meshGeometry) const = 0;

  /**
  * Gets the unit normal vector to the surface's plane.
  * An application does not need to override this method.
  * 
  * @param[in] meshGeometry The geometry of the mesh. Used to retrieve the node coordinates
  * of this cell.
  */
  virtual MbVec3d getNormal(const MiGeometryI* meshGeometry) const = 0;

};

#ifdef _WIN32
#  pragma warning( pop )
#endif

#endif

