/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2017 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
#ifndef _MeXVolumeCell_H
#define _MeXVolumeCell_H

#ifdef _WIN32
#  pragma warning( push )
#  pragma warning(disable:4250)
#endif

#include <MeshVizXLM/mesh/cell/MiVolumeCell.h>

#include <Inventor/STL/vector>
#include <Inventor/STL/utility>

/**
* @DTEXT  Defines an abstract cell of an extracted volume mesh.
* 
* @ingroup MeshVizXLM_ExtractedMesh_Cell
* 
* @DESCRIPTION
*    A volume cell is a polyhedron element that connects adjacent nodes of a volume mesh.
* 
*/

class MeXVolumeCell : public MiVolumeCell
{
public:
  /**
  * Gets the normal to the given facet of the cell.
  * An application does not need to override this method.
  * 
  * @param[in] facet The index of the facet (where 0 <= facet < getNumFacets()).
  * @param[in] meshGeometry The geometry of the mesh. Used to retrieve the node coordinates
  * of this cell.
  * @return a vector.
  */
  virtual MbVec3d getFacetNormal(size_t facet, const MiGeometryI* meshGeometry) const = 0;

  /**
  * Gets the volume of the cell.
  * An application does not need to override this method.
  * 
  * @param[in] meshGeometry The geometry of the mesh. Used to retrieve the node coordinates
  * of this cell.
  */
  virtual double getVolume(const MiGeometryI* meshGeometry) const = 0;

};


#ifdef _WIN32
#  pragma warning( pop )
#endif

#endif


