/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2017 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
#ifndef _MeXGeometryRegular_H
#define _MeXGeometryRegular_H

#include <MeshVizXLM/extrmesh/geometry/MeXGeometry.h>
#include <MeshVizXLM/mesh/geometry/MiGeometryRegular.h>

/**
* @DTEXT Extracted generic parallelepiped, rectangular or straight line geometry.
* 
* @ingroup MeshVizXLM_ExtractedMesh_Geometry
* 
* @DESCRIPTION
*    A generic abstract interface for a parallelepiped geometry,
*    a rectangle geometry or a straight line geometry.
*    The geometry is given by two points defining two extremities.
*    (see getMin() and getMax()).
* 
*/
class MeXGeometryRegular : public MiGeometryRegular, virtual public MeXGeometry
{
public:
  /**
  * Returns the minimum value of this set.
  */
  virtual MbVec3d getMin() const = 0;
  /**
  * Returns the maximum value of this set.
  */
  virtual MbVec3d getMax() const = 0;
};

#endif


