/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2017 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
#ifndef _MeWSurfaceTopologyExplicitI_h
#define _MeWSurfaceTopologyExplicitI_h


#include <MeshVizXLM/extrmesh/topology/MeXSurfaceTopologyExplicitI.h>

/**
* @DTEXT Abstract interface to write unstructured surface mesh topology.
* 
* @ingroup MeshVizXLM_ExtractedMesh_Topology
* 
* @DESCRIPTION
*    This interface is used by the existing tessellator instances (see MiTessellator)
*    to write the topology of the tessellated surface meshes.
*    It is designed to allow the application to implement its own tessellator class.
*
*/
class MeWSurfaceTopologyExplicitI : virtual public MeXSurfaceTopologyExplicitI
{
public:

  /**
  * Add a new tessellated surface cell in the topology. For instance
  * if the tessellator builds the tessellated mesh using always triangles,
  * this method is called by giving the 3 node ids for each triangle
  * of the tessellation.
  * @param[in] numNodes Number of nodes in the tessellated surface cell.
  * @param[in] nodeIds List of nodes id in the tessellated surface cell.
  */
  virtual void addPolygon(size_t numNodes, const size_t* nodeIds) = 0;

};


#endif

