/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2023 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
#ifndef  _MO_MESHVIZ_
#define  _MO_MESHVIZ_

#include <MeshVizXLM/mapping/MoMeshVizDataMapping.h>

/**
 * @DTEXT Class to initialize all MeshViz XLM nodes.
 * 
 * @ingroup MeshVizXLM_Mapping
 * 
 * @DESCRIPTION
 *   This class initializes both the Mesh Extraction and Data Mapping modules
 *   of MeshViz XLM (it is not necessary to initialize #MiMeshViz if
 *   using this class). Initialization must be done before creating or
 *   using any other MeshViz XLM classes.
 * 
 * 
 */ 

class MESHVIZXLM_DMAP_API MoMeshViz {

 public:

  /**
   * Initializes all classes in the Mesh Extraction and Data Mapping modules
   * (automatically calls the MiMeshViz::init method).
   * This function or MoMeshViz::init() must be called before creating or using any 
   * other MeshViz XLM classes.
   * @param numThreads is the number of threads that mesh representation nodes, such as MoMeshSkin,
   *                   allocate for their extraction algorithm when their parallel field is set to true.
   *                   If numThreads is not 1, multiple threads can be used during every extraction algorithm.
   *                   In that case, all the methods of the geometry and topology interfaces must be thread-safe as they can be called concurrently.
   *                   For instance, for unstructured mesh, pay particular attention to the implementation of the methods getCoord,
   *                   getCell and the methods that implement the MiCell interface.
   *                   If numThreads is 0, it allocates the maximum number of threads available.
   *                   If numThreads is negative, it allocates the maximum number of threads available decreased by the given number.
   *                   For instance, value -2 allocates the maximum number of threads available minus 2.
   */
  static void init(int numThreads);

  /**
   * Equivalent to MoMeshViz::init(0)
   */
  static void init();

	/**
   * Finishs all classes in the Mesh Extraction and Data Mapping modules
   * (automatically calls the MiMeshViz::finish method).
   * This function should be called after all MeshViz XLM objects
   * have been destroyed, to ensure that any static memory allocations
   * are freed.
   */
	static void finish();

  /**
   * Returns TRUE if module is currently initialized.
   */
  static bool isInitialized();

  /**
   * Returns a character string identifying the name of the extension.
   */
  static const char *getProductName();

#if SoDEPRECATED_BEGIN(2023200)
  /**
   * Returns a character string identifying the version of the extension.
   */
  SoDEPRECATED_METHOD(2023.2, "This method should no longer be used. Use SoLicensesInfo::getVersion() method instead.")
  static const char *getVersion();
#endif /** @DEPRECATED_END */

 SoINTERNAL public:

  // Internal function, will be removed in next minor version
  static bool checkBYCInternal();

  // Init/finish ref counter status
  static int s_initRefCount;

  static const char *s_versionString;
} ;
/*---------------------------------------------------------------------------*/

#endif /* _MO_MESHVIZ_ */

