/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2017 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
#ifndef _MOMESHVIZDATAMAPPING_H
#define _MOMESHVIZDATAMAPPING_H

#include <MeshVizXLM/MxMeshVizXLM.h>

#include <Inventor/sys/port.h>
#include <MeshVizXLM/mapping/MoMeshVizDataMappingLibName.h>

//  MeshVizExtractor_EXPORTS is defined only when building MeshViz extractor dll
#ifdef _WIN32
#  ifdef MeshVizDataMapping_EXPORTS
#    define MESHVIZXLM_DMAP_API VC_DLL_EXPORT
#  else
#    define MESHVIZXLM_DMAP_API VC_DLL_IMPORT
#    ifndef OIV_DISABLE_AUTOLINK
#      pragma comment(lib,__MESHVIZDATAMAPPINGLIB)
#    endif
#  endif
#else
#  define  MESHVIZXLM_DMAP_API GCC_DLLEXPORT
#endif

#include <Inventor/actions/SoCallbackAction.h>
#include <Inventor/actions/SoGLRenderAction.h>
#include <Inventor/actions/SoGetMatrixAction.h>
#include <Inventor/actions/SoSearchAction.h>
#include <Inventor/actions/SoGetBoundingBoxAction.h>
#include <Inventor/actions/SoWriteAction.h>
#include <Inventor/actions/SoHandleEventAction.h>
#include <Inventor/actions/SoPickAction.h>
#include <Inventor/actions/SoGetPrimitiveCountAction.h>

#include <Inventor/SoModule.h>
SO_MODULE_HEADER(SoMeshVizDataMapping, __MESHVIZDATAMAPPINGDLL)

// Macro that allows to enable an element for all type of actions
#define MO_ENABLE_ELT_ALL_ACTIONS(_elt)\
SO_ENABLE(SoCallbackAction, _elt);\
SO_ENABLE(SoGLRenderAction, _elt);\
SO_ENABLE(SoGetMatrixAction, _elt);\
SO_ENABLE(SoSearchAction, _elt);\
SO_ENABLE(SoGetBoundingBoxAction, _elt);\
SO_ENABLE(SoWriteAction, _elt);\
SO_ENABLE(SoHandleEventAction, _elt);\
SO_ENABLE(SoPickAction, _elt);\
SO_ENABLE(SoGetPrimitiveCountAction, _elt);

/**
 * @ingroup MeshVizXLM_Mapping
 * 
 *   All supported mesh types
 * 
 */ 
enum MeshType {
  VOLUME_MESH_UNSTRUCTURED,      /**< Unstructured Volume Mesh */
  VOLUME_MESH_HEXAHEDRON_IJK,    /**< Structured Hexahedron Mesh */
  HEXAHEDRON_MESH_IJK,           /**< Structured Vertex Hexahedron Mesh */
  VOLUME_MESH_REGULAR,           /**< Regular Volume Mesh */
  VOLUME_MESH_RECTILINEAR,       /**< Rectilinear Volume Mesh */
  VOLUME_MESH_CURVILINEAR,       /**< Curvilinear Volume Mesh */
  SURFACE_MESH_UNSTRUCTURED,     /**< Unstructured Surface Mesh */
  SURFACE_MESH_REGULAR,          /**< Regular Surface Mesh */
  SURFACE_MESH_RECTILINEAR,      /**< Rectilinear Surface Mesh */
  SURFACE_MESH_CURVILINEAR,      /**< Curvilinear Surface Mesh */
  LINE_MESH_UNSTRUCTURED,        /**< Unstructured Line Mesh */
  LINE_MESH_REGULAR,             /**< Regular Line Mesh */
  LINE_MESH_CURVILINEAR,         /**< Curvilinear Line Mesh */
  POINT_MESH_CURVILINEAR,        /**< Curvilinear Point Mesh */
  UNDEFINED_MESH                 /**< Mesh not defined */
};

/**
 * @ingroup MeshVizXLM_Mapping
 * 
 *   Type of cell filter
 * 
 */ 
enum CellFilterType {
  CELL_FILTER_I,        /**< Cell Filter for unstructured meshes */
  CELL_FILTER_IJ,       /**< Cell Filter for structured surface meshes */
  CELL_FILTER_IJK,       /**< Cell Filter for structured volume meshes */
  UNDEFINED_CELL_FILTER /**< Cell Filter not defined */
};
 
#endif


