/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2017 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : Martial Bonaventure (Dec 2010)
**=======================================================================*/


#ifndef _MO_LINEDETAILIJ_
#define _MO_LINEDETAILIJ_

#include <MeshVizXLM/mapping/details/MoLineDetail.h>

//////////////////////////////////////////////////////////////////////////////
//
//  Class: MoLineDetailIj
//
//  Detail information about vertex-based shapes made of line segments. It
//  adds indices of the input cell in a structured surface mesh. 
//
//
//////////////////////////////////////////////////////////////////////////////

/**
 * Stores detail information about vertex-based shapes made of line segments
 * from structured surface meshes.
 * 
 * @ingroup MeshVizXLM_Mapping_Details
 * 
 * @DESCRIPTION
 *   This class contains detail information about a line segment in a
 *   vertex-based shape made of line segments (extends MoLineDetail).  
 *   Additional information includes the I/J indices of the cell containing the line segment
 *   in the structured surface mesh stored in the associated MoMeshDetail 
 *   (see MoLineDetail::getMeshDetail()).
 *  
 * 
 * @SEE_ALSO
 *    SoDetail,
 *    MoLineDetail,
 *    MoMeshDetail,
 *    MoSurfaceMeshDetail,
 *    SoPickedPoint,
 *    SoPrimitiveVertex,
 *    SoVertexShape
 * 
 */ 

class MESHVIZXLM_DMAP_API MoLineDetailIj : public MoLineDetail {

  SO_DETAIL_HEADER(MoLineDetailIj);

 public:
  /**
   * Constructor.
   */
  MoLineDetailIj();
  /**
   * Destructor.
   */
  virtual ~MoLineDetailIj();

  //@{
  /**
  * Returns the index of the cell containing the face within the input mesh.
  */
  size_t                      getCellIndexI() const    { return m_cellIndexI; }
  size_t                      getCellIndexJ() const    { return m_cellIndexJ; }
  //@}

  // Returns an instance that is a copy of this instance. The caller
  // is responsible for deleting the copy when done.
  virtual MoLineDetailIj *      copy() const;

 SoEXTENDER public:
  // Copies the given details
  MoLineDetailIj(const MoLineDetail* lineDetail, const MoMeshDetail* meshDetail);

 SoINTERNAL public:
  static void                 initClass();
  static void                 exitClass();

 private:
  size_t                      m_cellIndexI;
  size_t                      m_cellIndexJ;

};

#endif /* _MO_LINEDETAILIJ_ */

