/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2018 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : Martial Bonaventure (Nov 2010)
**=======================================================================*/


#ifndef _MO_MESHREPRESENTATIONDETAIL_
#define _MO_MESHREPRESENTATIONDETAIL_

#ifdef _WIN32
#  pragma warning( push )
#  pragma warning(disable:4251)
#endif

#include <Inventor/details/SoSubDetail.h>
#include <Inventor/STL/vector>

#include <MeshVizXLM/extrmesh/data/MeXDataSetI.h>
#include <MeshVizXLM/mapping/MoMeshVizDataMapping.h>

class MiMeshUnstructuredI;

//////////////////////////////////////////////////////////////////////////////
//
//  Class: MoMeshRepresentationDetail
//
//  Detail information about a mesh representation.
//
//
//////////////////////////////////////////////////////////////////////////////

/**
 * Stores detail information about a mesh representation.
 * 
 * @ingroup MeshVizXLM_Mapping_Details
 * 
 * @DESCRIPTION
 *   This class contains detail information about a mesh representation. 
 *   It includes the mapped scalarset used for coloring.
 * 
 * @SEE_ALSO
 *    SoDetail,
 *    MoFaceDetail,
 *    MoLineDetail
 *    MeXScalardSetI
 * 
 */ 

class MESHVIZXLM_DMAP_API MoMeshRepresentationDetail : public SoDetail {

 SO_DETAIL_HEADER(MoMeshRepresentationDetail);

 public:
  /**
   * Constructor.
   */
  MoMeshRepresentationDetail();
  /**
   * Destructor.
   */
  virtual ~MoMeshRepresentationDetail();

  /*
  * Returns the first mapped scalarset used for coloring the mesh representation
  */
  const MeXScalardSetI* getExtractedColorScalarSet() const;

  /*
  * Returns the list of mapped scalarsets used for coloring the mesh representation
  */
  const std::vector<const MeXScalardSetI*>& getExtractedColorScalarSets() const   { return m_extractedColorScalarsets; }

  // Returns an instance that is a copy of this instance. The caller
  // is responsible for deleting the copy when done.
  virtual MoMeshRepresentationDetail *  copy() const = 0;

 SoEXTENDER public:
  MoMeshRepresentationDetail(const MiMeshUnstructuredI* mesh, const std::vector<const MeXScalardSetI*>& scalarsets);

  // Computes the values of the scalarsets in the cell defined by the index at the given point.
  // Returns an empty vector if point is not inside the cell.
  std::vector<double> computeValues(const MbVec3d& point, int32_t index) const;

 SoINTERNAL public:
  static void                 initClass();
  static void                 exitClass();

private:
  const MiMeshUnstructuredI*  m_mesh;
  std::vector<const MeXScalardSetI*>       m_extractedColorScalarsets;

};

#ifdef _WIN32
#  pragma warning( pop )
#endif

#endif /* _MO_MESHREPRESENTATIONDETAIL_ */

