/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2018 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : Martial Bonaventure (Dec 2010)
**=======================================================================*/


#ifndef _MO_SURFACEMESHDETAIL_
#define _MO_SURFACEMESHDETAIL_

#include <MeshVizXLM/mapping/details/MoMeshRepresentationDetail.h>

#include <MeshVizXLM/extrmesh/data/MeXDataSetI.h>

class MeXSurfaceMeshUnstructured;

//////////////////////////////////////////////////////////////////////////////
//
//  Class: MoSurfaceMeshDetail
//
//  Detail information about a mesh representation defined by a surface.
//
//
//////////////////////////////////////////////////////////////////////////////

/**
 * Stores detail information about a mesh representation defined by a surface.
 * 
 * @ingroup MeshVizXLM_Mapping_Details
 * 
 * @DESCRIPTION
 *   This class contains detail information about a mesh representation defined by a
 *   surface. It includes the extracted surface. 
 * 
 * @SEE_ALSO
 *    SoDetail,
 *    MoMeshRepresentationDetail
 *    MoFaceDetail,
 *    MeXSurfaceMeshUnstructured,
 * 
 */ 

class MESHVIZXLM_DMAP_API MoSurfaceMeshDetail : public MoMeshRepresentationDetail {

 SO_DETAIL_HEADER(MoSurfaceMeshDetail);

 public:
  /**
   * Constructor.
   */
  MoSurfaceMeshDetail();
  /**
   * Destructor.
   */
  virtual ~MoSurfaceMeshDetail();

  /*
  * Returns the extracted surface
  */
  const MeXSurfaceMeshUnstructured* getExtractedMesh() const   { return m_extractedMesh; }

  // Returns an instance that is a copy of this instance. The caller
  // is responsible for deleting the copy when done.
  virtual MoSurfaceMeshDetail *  copy() const;

 SoEXTENDER public:
  MoSurfaceMeshDetail(const MeXSurfaceMeshUnstructured* mesh, const std::vector<const MeXScalardSetI*>& scalarsets);

 SoINTERNAL public:
  static void                 initClass();
  static void                 exitClass();

private:
  const MeXSurfaceMeshUnstructured*   m_extractedMesh;

};

#endif /* _MO_SURFACEMESHDETAIL_ */

