/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2018 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
** Modified by : 
**=======================================================================*/

#pragma once

#include <Inventor/elements/SoReplacedElement.h>
#include <Inventor/SbColorRGBA.h>
#include <Inventor/STL/vector>
#include <MeshVizXLM/mapping/interfaces/MiColorMapping.h>

/**
* @DTEXT Stores the current combine color mapping.
* 
* @ingroup MeshVizXLM_Mapping_Elements
*
* @DESCRIPTION
*   This element stores the current combine color mapping.
*
* @SEE_ALSO
*   MoCustomColorMapping, MoLevelColorMapping, MoLinearColorMapping, MoPredefinedColorMapping
*
*/
class MESHVIZXLM_DMAP_API MoCombineColorMappingElement : public SoReplacedElement {

  SO_ELEMENT_HEADER(MoCombineColorMappingElement);
  
 public:

  /** Sets the current color mapping */
  static void set(SoState *state, SoNode *node, const MiColorMapping<std::vector<double>,SbColorRGBA> *colorMapping);
  
  /** Returns the current color mapping from the state */
  static const MiColorMapping<std::vector<double>, SbColorRGBA> *getColorMapping(SoState *state);

  /**
  *  Prints element (for debugging).
  */
  virtual void        print(FILE *fp) const;

protected:

  /** Initializes element */
  virtual void init(SoState *state);

  /**
  *  Returns TRUE if the geoOrigins match in both elements.
  */
  virtual SbBool matches(const SoElement* elt) const;

  /**
  *  Create and return a copy of this element.
  */
  virtual SoElement *copyMatchInfo() const;

 SoINTERNAL public:
  // Initializes the class
  static void initClass();
  static void exitClass() ;

 protected:
  
   virtual ~MoCombineColorMappingElement();

  const MiColorMapping<std::vector<double>, SbColorRGBA>* m_colorMapping;
  size_t m_colorMapTimeStamp;
};
/*----------------------------------------------------------------------------*/


