/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2018 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
** Modified by : M. Bonaventure (Mar 2010)
**=======================================================================*/
/*==============================================================================
 *   File        : MoMaterialElement.h
 *   Classes     : MoMaterialElement
 *   Author(s)   : Pascal Doux
 *   Date        : 18 11 2008
 *==============================================================================
 *
 * Description : Element that stores a mesh material.
 *
 *============================================================================*/

#ifndef  _MO_MATERIAL_ELEMENT_
#define  _MO_MATERIAL_ELEMENT_

#include <Inventor/elements/SoReplacedElement.h>
#include <MeshVizXLM/mapping/MoMeshVizDataMapping.h>
#include <MeshVizXLM/mapping/nodes/MoMaterial.h>

class MoDataBinding;

/**
* @DTEXT Stores the current material.
* 
* @ingroup MeshVizXLM_Mapping_Elements
*
* @DESCRIPTION
*   This element stores the current colors and coloring options.
* @SEE_ALSO
*   MoMaterial
*/
class MESHVIZXLM_DMAP_API MoMaterialElement : public SoReplacedElement {

  SO_ELEMENT_HEADER(MoMaterialElement);

public:

  /** Sets the current material */
  static void set(SoState *state, SoNode *node, MoMaterial::ColoringType coloring,const SbColor& color,
    MoMaterial::ColoringType lineColoring,const SbColor& lineColor, 
    MoMaterial::ColoringType markerColoring, const SbColor& markerColor, 
    float transparency, bool enhancedColoring);

  /** Returns the current Material from the state */
  static bool getMaterial(SoState *state, MoMaterial::ColoringType& coloring, SbColor& color, 
    MoMaterial::ColoringType& lineColoring, SbColor& lineColor, 
    MoMaterial::ColoringType& markerColoring, SbColor& markerColor, 
    float& transparency, bool& enhancedColoring);

  /** Returns the current coloring type Material from the state */
  static bool getColoringTypes(SoState *state, MoMaterial::ColoringType& coloring,
                                               MoMaterial::ColoringType& lineColoring,
                                               MoMaterial::ColoringType& markerColoring);

  static bool getEnhancedColoring( SoState* state );

  /** Returns the default Material from the state */
  static bool getDefault(MoMaterial::ColoringType& coloring, SbColor& color, 
    MoMaterial::ColoringType& lineColoring, SbColor& lineColor, 
    MoMaterial::ColoringType& markerColoring, SbColor& markerColor, 
    float& transparency, bool& enhancedColoring);

  /**
  *  Prints element (for debugging).
  */
  virtual void        print(FILE *fp) const;

protected:

  /** Initializes element */
  virtual void init(SoState *state);

  /**
  *  Returns TRUE if the geoOrigins match in both elements.
  */
  virtual SbBool matches(const SoElement* elt) const;

  /**
  *  Create and return a copy of this element.
  */
  virtual SoElement* copyMatchInfo() const;

 SoINTERNAL public:
  // Initializes the class
  static void initClass();
	static void exitClass() ;

 protected:
   MoMaterial::ColoringType   m_coloring;
   SbColor                    m_color;
   MoMaterial::ColoringType   m_lineColoring;
   SbColor                    m_lineColor;
   MoMaterial::ColoringType   m_markerColoring;
   SbColor                    m_markerColor;
   float                      m_transparency;
   bool                       m_enhancedColoring;
   bool                       m_isSet;

  virtual ~MoMaterialElement();
  
};
/*----------------------------------------------------------------------------*/

#endif // _MO_MATERIAL_ELEMENT_


