/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2017 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
** Modified by : M. Bonaventure (Mar 2010)
**=======================================================================*/
/*==============================================================================
 *   File        : MoMeshElement.h
 *   Classes     : MoMeshElement
 *   Author(s)   : Pascal Doux
 *   Date        : 6 6 2008
 *==============================================================================
 *
 * Description : Element that stores a mesh.
 *
 *============================================================================*/

#ifndef  _MO_MESH_ELEMENT_
#define  _MO_MESH_ELEMENT_

#include <Inventor/elements/SoReplacedElement.h>
#include <MeshVizXLM/mapping/MoMeshVizDataMapping.h>

class MiVolumeMeshUnstructured;
class MiMesh;
class MoMeshRepresentation;

/**
* @DTEXT Stores the current mesh.
* 
* @ingroup MeshVizXLM_Mapping_Elements
*
* @DESCRIPTION
*   This element stores the current mesh interface.
* @SEE_ALSO
*   MoMesh
*/
class MESHVIZXLM_DMAP_API MoMeshElement : public SoReplacedElement {

  SO_ELEMENT_HEADER(MoMeshElement);
  
public:
  /** Sets the current mesh */
  static void set(SoState *state, SoNode *node, MeshType meshType, const MiMesh *mesh , MoMeshRepresentation* meshRepresentation, size_t nodeTimeStamp);
  
  /** Returns the current mesh from the state */
  static const MiMesh *getMesh(SoState *state, MeshType &meshType, size_t& meshTimeStamp);
  
  /** Returns the current representation connected to the mesh from the state */
  static MoMeshRepresentation *getConnectedRepresentation(SoState *state, MeshType &meshType);

  /**
  *  Prints element (for debugging).
  */
  virtual void        print(FILE *fp) const;

protected:

  /** Initializes element */
  virtual void init(SoState *state);

  /**
  *  Returns TRUE if the geoOrigins match in both elements.
  */
  virtual SbBool matches(const SoElement* elt) const;

  /**
  *  Create and return a copy of this element.
  */
  virtual SoElement* copyMatchInfo() const;

 SoINTERNAL public:
  // Initializes the class
  static void initClass();
  static void exitClass() ;

  size_t getTimeStamp() const;
  
 protected:
  const MiMesh *m_mesh;
  MeshType      m_meshType;
  size_t        m_nodeTimeStamp;
  MoMeshRepresentation *m_connectFrom;
  
  virtual ~MoMeshElement();
  
};
/*----------------------------------------------------------------------------*/

#endif // _MO_MESH_ELEMENT_


