/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2017 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
/*==============================================================================
 *   File        : MoScalarSetElementI.h
 *   Classes     : MoScalarSetElementI
 *   Author(s)   : Pascal Doux
 *   Date        : 6 6 2008
 *==============================================================================
 *
 * Description : Element that stores a scalar set I.
 *
 *============================================================================*/

#ifndef  _MO_SCALARSET_ELEMENTI_
#define  _MO_SCALARSET_ELEMENTI_

#include <Inventor/elements/SoAccumulatedElement.h>
#include <MeshVizXLM/mesh/data/MiDataSetI.h>


/**
* @DTEXT Stores a list of scalar sets for unstructured meshes.
* 
* @ingroup MeshVizXLM_Mapping_Elements
*  
* @DESCRIPTION
*   This element stores a list of unstructured scalar data sets.
* @SEE_ALSO
*   MoScalarSetI
*/
SoEXTENDER_Documented class MESHVIZXLM_DMAP_API MoScalarSetElementI : public SoAccumulatedElement {

  SO_ELEMENT_HEADER(MoScalarSetElementI);
  
 public:
  /**
  *  Adds a ScalarSet to the current set in the state.
  */
  static void add(SoState *state, SoNode *node,const MiScalardSetI *scalarSet);

  /**
  *  Get number of elements in the state.
  */
  static int getNum(SoState *state);

  /**
  *  Get the element number index from the state.
  */
  static const MiScalardSetI * get(SoState *state,int index);
  
  /**
  *  Push the element into the state.
  */
  virtual void push(SoState *);

protected:

  /** Initializes element */
  virtual void init(SoState *state);

SoINTERNAL public:
  // Initializes the class
  static void initClass();
	static void exitClass() ;

 protected:
  
  SbPList m_scalarSets;   // List of scalar sets 

  virtual ~MoScalarSetElementI();
  
};
/*----------------------------------------------------------------------------*/

#endif // _MO_SCALARSET_ELEMENTI_

