/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2017 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
#ifndef _MICOLORMAPPING_H
#define _MICOLORMAPPING_H

#include <MeshVizXLM/MxMeshVizXLM.h>
#include <MeshVizXLM/MiAbstractMethodError.h>

/**
* @DTEXT Interface class defining a color mapping function.
* 
* @ingroup MeshVizXLM_Mapping_Attributes
* 
* @DESCRIPTION
*   This abstract class specifies the interface used to map a value of a scalar data set to a color.
*   It is used when displaying scalar data sets as colors.
* 
*   In order to define a custom color mapping, create a class derived from this class. 
* 
*/

template <typename _TValue, typename _TColor>
class MiColorMapping 
{
public:
  virtual ~MiColorMapping() {}

  /**
  * Returns the color associated with the given value. 
  */
  virtual _TColor getColor(_TValue value) const = 0;

  /**
  * Returns the range of values for the colormap. 
  * @note This method should be pure virtual, but, for compatibility reasons, it throws an exception instead.
  */
  virtual void getRange(_TValue& SO_UNUSED_PARAM(min), _TValue& SO_UNUSED_PARAM(max)) const
  {
    throw MiAbstractMethodError("MiColorMapping::getRangeValue(_TValue& min, _TValue& max)");
  }

  /**
  * Returns for this colormap a unique time stamp across all colormaps in the application.
  * When the content of the colormap changes, the time stamp must increase. The time stamp 
  * allows representations to identify this colormap and to be aware of any changes to it.
  * @note MxTimeStamp can be used to generate a valid time stamp.
  */
  virtual size_t getTimeStamp() const = 0;

};



#endif /* _MICOLORMAPPING_H */







