/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2017 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/

#ifndef  _MO_CELLFILTER_
#define  _MO_CELLFILTER_

#include <MeshVizXLM/mapping/nodes/MoActionNode.h>
#include <MeshVizXLM/mapping/MoMeshVizDataMapping.h>
 
class MiCellFilter;

/**
 * @DTEXT Property node that defines a cell filter.
 * 
 * @ingroup MeshVizXLM_Mapping_Attributes
 * 
 * @DESCRIPTION
 *   Filtering cells is a way to specify which cells are used and which cells are ignored during a mesh extraction.
 *   The application must create a class implementing the MiCellFilter interface.
 *   A cell filter class must implement the method
 *   acceptCell() with either 1, 2 or 3 indices as arguments.
 *   When the method acceptCell() returns false, the cell identified
 *   by these indices is not taken into account by the extraction. 
 *   It is as if the mesh does not contain this cell.
 *
 * @note Each time the current MiCellFilter is updated, touch() must be called
 * to mark the node as modified. However MiCellFilter::getTimeStamp() must return a different 
 * value than before to actually trigger a new rendering.
 *
 * @FILE_FORMAT_DEFAULT
 *    CellFilter {
 *    @TABLE_FILE_FORMAT
 *    @TABLE_END
 *    }
 *
 * @ACTION_BEHAVIOR
 *   Sets the current cell filter.  See MoCellFilterElement.
 *
 * @SEE_ALSO
 *    MiCellFilter, MiCellFilterI, MiCellFilterIj, MiCellFilterIjk
 * 
 */
class MESHVIZXLM_DMAP_API MoCellFilter : public MoActionNode {

  SO_NODE_HEADER(MoCellFilter) ;
  
 public:

  /**
   * Constructor.
   */
  MoCellFilter() ;

  /**
  * Provides a common interface to set all cell filter types (MiCellFilterI, 
  * MiCellFilterIj and MiCellFilterIjk) and marks the node as modified by calling touch().
  * The given cellFilter is checked to ensure a required type is provided. If not,
  * NULL is set instead.
  * @note When setting a new filter, the MiCellFilter::getTimeStamp() must return a different
  * value than previously to actually take into account the change of filter.
  */
  virtual void setCellFilter(const MiCellFilter* cellFilter);

  /**
  * Reset the cell filter interface to NULL (as if setCellFilter was given a NULL pointer). 
  * Marks this node as modified by calling touch()
  * 
  */
  virtual void reset();

  /**
   * Gets the cell filter interface.
   * Use RTTI to find out which derived class it is.
   */
  virtual const MiCellFilter* getCellFilter();

 /*----------------------------------------------------------------------------*/
  SoINTERNAL public:
  static void initClass() ;
	static void exitClass() ;
  
  SoEXTENDER public:
  virtual void  doAction(SoAction *action) ;

protected:
  virtual ~MoCellFilter() ;

  const MiCellFilter* m_cellFilter;
  CellFilterType m_cellFilterType;

} ; 

#endif /* _MO_CELLFILTER_  */

